/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.transport.local.LocalResponder;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ServiceInMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ServiceInOutSyncMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ServiceProvider;
import org.apache.tuscany.sca.common.xml.XMLDocumentHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ClassLoaderContext;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Axis2EngineIntegration {
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName QNAME_WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    public static final String ELEM_SCHEMA = "schema";
    public static final String NS_URI_XSD_1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String NS_URI_XSD_2000 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String NS_URI_XSD_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final QName Q_ELEM_XSD_1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    public static final List<QName> XSD_QNAME_LIST = Arrays.asList(Q_ELEM_XSD_1999, Q_ELEM_XSD_2000, Q_ELEM_XSD_2001);
    private static Axis2Config axis2Config;

    public static synchronized ConfigurationContext getAxisConfigurationContext(final ServiceDiscovery serviceDiscovery) {
        if (axis2Config == null) {
            try {
                axis2Config = AccessController.doPrivileged(new PrivilegedExceptionAction<Axis2Config>(){

                    @Override
                    public Axis2Config run() throws AxisFault, MalformedURLException {
                        ClassLoader wsBindingCL = this.getClass().getClassLoader();
                        ClassLoader axis2CL = URLBasedAxisConfigurator.class.getClassLoader();
                        ClassLoader localtransportCL = LocalResponder.class.getClassLoader();
                        ClassLoaderContext classLoaderContext = new ClassLoaderContext(wsBindingCL, new ClassLoader[]{axis2CL, localtransportCL});
                        classLoaderContext = new ClassLoaderContext(classLoaderContext.getClassLoader(), serviceDiscovery, new Class[]{XMLInputFactory.class, DocumentBuilderFactory.class});
                        URL axis2xmlURL = wsBindingCL.getResource("org/apache/tuscany/sca/binding/ws/axis2/engine/conf/tuscany-axis2.xml");
                        if (axis2xmlURL != null) {
                            URL repositoryURL = new URL(axis2xmlURL, "../repository/");
                            Axis2Config config = new Axis2Config();
                            config.classLoaderContext = classLoaderContext;
                            config.axis2xmlURL = axis2xmlURL;
                            config.repositoryURL = repositoryURL;
                            return config;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ServiceRuntimeException((Throwable)e.getException());
            }
        }
        if (axis2Config == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ConfigurationContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ConfigurationContext run() throws AxisFault {
                    ClassLoader oldTCCL = axis2Config.classLoaderContext.setContextClassLoader();
                    try {
                        ConfigurationContext configurationContext;
                        ConfigurationContext configurationContext2 = configurationContext = ConfigurationContextFactory.createConfigurationContextFromURIs(axis2Config.axis2xmlURL, axis2Config.repositoryURL);
                        return configurationContext2;
                    }
                    finally {
                        if (oldTCCL != null) {
                            Thread.currentThread().setContextClassLoader(oldTCCL);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServiceRuntimeException((Throwable)e.getException());
        }
    }

    public static AxisService createJavaAxisService(String endpointURL, ConfigurationContext configContext, AbstractContract contract) throws AxisFault {
        AxisService axisService = new AxisService();
        String path = URI.create(endpointURL).getPath();
        axisService.setName(path);
        axisService.setServiceDescription("Tuscany configured AxisService for service: " + endpointURL);
        axisService.setClientSide(false);
        Parameter classParam = new Parameter("ServiceClass", ((JavaInterface)contract.getInterfaceContract().getInterface()).getJavaClass().getName());
        axisService.addParameter(classParam);
        try {
            Utils.fillAxisService(axisService, configContext.getAxisConfiguration(), null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return axisService;
    }

    public static AxisService createWSDLAxisService(String endpointURL, Port port, WebServiceBinding wsBinding) throws AxisFault {
        AxisService axisService;
        Definition definition = wsBinding.getWSDLDocument();
        QName serviceQName = wsBinding.getService().getQName();
        Definition def = Axis2EngineIntegration.getDefinition(definition, serviceQName);
        final WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(def, serviceQName, port.getName());
        builder.setServerSide(true);
        builder.setCustomResolver(new URIResolverImpl(def));
        builder.setBaseUri(def.getDocumentBaseURI());
        try {
            axisService = AccessController.doPrivileged(new PrivilegedExceptionAction<AxisService>(){

                @Override
                public AxisService run() throws AxisFault {
                    return builder.populateService();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)e.getException();
        }
        String name = URI.create(endpointURL).getPath();
        if (endpointURL.startsWith("jms")) {
            name = name.startsWith("/") ? name.substring(1) : name;
        }
        axisService.setName(name);
        axisService.setEndpointURL(endpointURL);
        axisService.setDocumentation("Tuscany configured AxisService for service: " + endpointURL);
        for (AxisEndpoint ae : axisService.getEndpoints().values()) {
            if (!endpointURL.startsWith("jms")) continue;
            break;
        }
        Axis2EngineIntegration.addSchemas(wsBinding.getWSDLDefinition(), axisService);
        Parameter wsdlParam = new Parameter("wsdl4jDefinition", null);
        wsdlParam.setValue(definition);
        axisService.addParameter(wsdlParam);
        Parameter userWSDL = new Parameter("useOriginalwsdl", "true");
        axisService.addParameter(userWSDL);
        Axis2EngineIntegration.modifySchemaImportsAndIncludes(definition, name);
        Parameter modifyAddr = new Parameter("modifyUserWSDLPortAddress", "false");
        axisService.addParameter(modifyAddr);
        return axisService;
    }

    private static Definition getDefinition(Definition definition, QName serviceName) {
        if (serviceName == null) {
            return definition;
        }
        if (definition == null) {
            return null;
        }
        Object service = definition.getServices().get(serviceName);
        if (service != null) {
            return definition;
        }
        for (Object i : definition.getImports().values()) {
            List imports = (List)i;
            for (Import imp : imports) {
                Definition d = Axis2EngineIntegration.getDefinition(imp.getDefinition(), serviceName);
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    private static void addSchemas(WSDLDefinition wsdlDef, AxisService axisService) {
        for (XSDefinition xsDef : wsdlDef.getXmlSchemas()) {
            if (xsDef.getSchema() == null) continue;
            axisService.addSchema(xsDef.getSchema());
            Axis2EngineIntegration.updateSchemaRefs(xsDef.getSchema(), axisService.getName());
        }
        for (WSDLDefinition impDef : wsdlDef.getImportedDefinitions()) {
            Axis2EngineIntegration.addSchemas(impDef, axisService);
        }
    }

    private static void updateSchemaRefs(XmlSchema parentSchema, String name) {
        Iterator iter = parentSchema.getIncludes().getIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal extSchema = (XmlSchemaExternal)obj;
            String location = extSchema.getSchemaLocation();
            if (location.length() > 0 && location.indexOf(":/") < 0 && location.indexOf("?xsd=") < 0) {
                extSchema.setSchemaLocation(name + "?xsd=" + location);
            }
            if (extSchema.getSchema() == null) continue;
            Axis2EngineIntegration.updateSchemaRefs(extSchema.getSchema(), name);
        }
    }

    private static void modifySchemaImportsAndIncludes(Definition definition, String name) {
        Types types = definition.getTypes();
        if (types != null) {
            for (Object ext : types.getExtensibilityElements()) {
                if (!(ext instanceof UnknownExtensibilityElement) || !XSD_QNAME_LIST.contains(((UnknownExtensibilityElement)ext).getElementType())) continue;
                Axis2EngineIntegration.changeLocations(((UnknownExtensibilityElement)ext).getElement(), name);
            }
        }
        for (Vector values : definition.getImports().values()) {
            for (Import wsdlImport : values) {
                Axis2EngineIntegration.modifySchemaImportsAndIncludes(wsdlImport.getDefinition(), name);
            }
        }
    }

    private static void changeLocations(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            Axis2EngineIntegration.processImport(nodeList.item(i), name);
        }
    }

    private static void processImport(Node importNode, String name) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String location;
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals("schemaLocation") || !((location = attribute.getNodeValue()).indexOf(":/") < 0 & location.indexOf("?xsd=") < 0)) continue;
            attribute.setNodeValue(name + "?xsd=" + location);
        }
    }

    public static void createAxisServiceProviders(AxisService axisService, RuntimeEndpoint endpoint, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints) {
        Iterator<AxisOperation> i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOp = i.next();
            Operation op = Axis2EngineIntegration.getOperation(axisOp, wsBinding);
            if (op == null) continue;
            if (op.isNonBlocking()) {
                axisOp.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
            } else {
                axisOp.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-out");
            }
            AbstractMessageReceiver msgrec = null;
            Axis2ServiceProvider serviceProvider = new Axis2ServiceProvider(endpoint, wsBinding, extensionPoints);
            msgrec = op.isNonBlocking() ? new Axis2ServiceInMessageReceiver(serviceProvider, op) : new Axis2ServiceInOutSyncMessageReceiver(serviceProvider, op);
            axisOp.setMessageReceiver(msgrec);
        }
    }

    private static Operation getOperation(AxisOperation axisOp, WebServiceBinding wsBinding) {
        String operationName = axisOp.getName().getLocalPart();
        Interface iface = wsBinding.getBindingInterfaceContract().getInterface();
        for (Operation op : iface.getOperations()) {
            if (!op.getName().equalsIgnoreCase(operationName)) continue;
            return op;
        }
        return null;
    }

    public static String getPortAddress(Port port) {
        Object ext = port.getExtensibilityElements().get(0);
        if (ext instanceof SOAPAddress) {
            return ((SOAPAddress)ext).getLocationURI();
        }
        if (ext instanceof SOAP12Address) {
            return ((SOAP12Address)ext).getLocationURI();
        }
        return null;
    }

    public static void setPortAddress(Port port, String locationURI) {
        Object ext = port.getExtensibilityElements().get(0);
        if (ext instanceof SOAPAddress) {
            ((SOAPAddress)ext).setLocationURI(locationURI);
        }
        if (ext instanceof SOAP12Address) {
            ((SOAP12Address)ext).setLocationURI(locationURI);
        }
    }

    @Deprecated
    public static AxisService createClientSideAxisService(Definition definition, QName serviceName, String portName, Options options) throws AxisFault {
        AxisService axisService;
        Definition def = Axis2EngineIntegration.getDefinition(definition, serviceName);
        final WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(def, serviceName, portName);
        serviceBuilder.setServerSide(false);
        serviceBuilder.setCustomResolver(new URIResolverImpl(def));
        serviceBuilder.setBaseUri(def.getDocumentBaseURI());
        try {
            axisService = AccessController.doPrivileged(new PrivilegedExceptionAction<AxisService>(){

                @Override
                public AxisService run() throws AxisFault {
                    return serviceBuilder.populateService();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)e.getException();
        }
        AxisEndpoint axisEndpoint = axisService.getEndpoints().get(axisService.getEndpointName());
        options.setTo(new EndpointReference(axisEndpoint.getEndpointURL()));
        if (axisEndpoint != null) {
            options.setSoapVersionURI((String)axisEndpoint.getBinding().getProperty("wsoap:version"));
        }
        return axisService;
    }

    public static class URIResolverImpl
    implements URIResolver {
        private Definition definition;

        public URIResolverImpl(Definition definition) {
            this.definition = definition;
        }

        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            try {
                if (baseUri == null) {
                    baseUri = this.definition.getDocumentBaseURI();
                }
                URL url = new URL(new URL(baseUri), schemaLocation);
                return XMLDocumentHelper.getInputSource((URL)url);
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class Axis2Config {
        private ClassLoaderContext classLoaderContext;
        private URL axis2xmlURL;
        private URL repositoryURL;

        private Axis2Config() {
        }
    }
}

