/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceProvider
implements Provider<OMElement> {
    private static final Logger logger = Logger.getLogger(Axis2ServiceProvider.class.getName());
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName QNAME_WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;
    private MessageFactory messageFactory;
    private FactoryExtensionPoint modelFactories;
    private RuntimeAssemblyFactory assemblyFactory;
    @Resource
    WebServiceContext wsContext;

    public Axis2ServiceProvider(RuntimeEndpoint endpoint, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints) {
        this.endpoint = endpoint;
        this.wsBinding = wsBinding;
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)this.modelFactories.getFactory(MessageFactory.class);
        this.assemblyFactory = (RuntimeAssemblyFactory)this.modelFactories.getFactory(AssemblyFactory.class);
    }

    public OMElement invoke(OMElement arg0) {
        return null;
    }

    public Object invokeTarget(Operation op, Object[] args, MessageContext inMC) throws InvocationTargetException {
        Message response;
        OMElement callbackAddrElement;
        OMElement from;
        String callbackAddress = null;
        Object callbackID = null;
        Message msg = this.messageFactory.createMessage();
        msg.setBody((Object)args);
        msg.setOperation(op);
        msg.setBindingContext((Object)inMC);
        SOAPHeader header = inMC.getEnvelope().getHeader();
        if (header != null && (from = header.getFirstChildWithName(QNAME_WSA_FROM)) != null && (callbackAddrElement = from.getFirstChildWithName(QNAME_WSA_ADDRESS)) != null && this.endpoint.getService().getInterfaceContract().getCallbackInterface() != null) {
            callbackAddress = callbackAddrElement.getText();
        }
        from = null;
        if (callbackAddress != null) {
            from = this.assemblyFactory.createEndpointReference();
            Endpoint fromEndpoint = this.assemblyFactory.createEndpoint();
            from.setTargetEndpoint(fromEndpoint);
            from.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
            msg.setFrom((EndpointReference)from);
            Endpoint callbackEndpoint = this.assemblyFactory.createEndpoint();
            callbackEndpoint.setURI(callbackAddress);
            callbackEndpoint.setUnresolved(true);
            from.setCallbackEndpoint(callbackEndpoint);
        }
        if ((response = this.endpoint.invoke(msg)).isFault()) {
            throw new InvocationTargetException((Throwable)response.getBody());
        }
        return response.getBody();
    }
}

