/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2EngineIntegration;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;

public class TuscanyListingAgent
extends ListingAgent {
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";

    public TuscanyListingAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
    }

    public String extractServiceName(String urlString) {
        String serviceName = this.findAxisServiceName(urlString);
        this.setContextRoot(urlString, serviceName);
        return serviceName;
    }

    public void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        int xsd;
        String url = req.getRequestURL().toString();
        String query = req.getQueryString();
        int wsdl = query.indexOf("wsdl");
        if (wsdl >= 0) {
            String serviceName = this.extractServiceName(url);
            HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
            if (services != null && !services.isEmpty()) {
                AxisService axisService = services.get(serviceName);
                Parameter wsld4jdefinition = axisService.getParameter("wsdl4jDefinition");
                Definition definition = (Definition)wsld4jdefinition.getValue();
                for (Object s : definition.getServices().values()) {
                    for (Object p : ((Service)s).getPorts().values()) {
                        String endpointURL = Axis2EngineIntegration.getPortAddress((Port)p);
                        String modifiedURL = TuscanyListingAgent.setIPAddress(endpointURL, url);
                        modifiedURL = this.addContextRoot(modifiedURL, serviceName);
                        Axis2EngineIntegration.setPortAddress((Port)p, modifiedURL);
                    }
                }
            }
        }
        if ((xsd = query.indexOf("xsd")) >= 0) {
            String xsds;
            AxisService serviceObj;
            String serviceName = this.extractServiceName(url);
            HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
            if (services != null && !services.isEmpty() && (serviceObj = services.get(serviceName)) != null && (xsds = req.getParameter("xsd")) != null && !"".equals(xsds)) {
                AxisService axisService = serviceObj;
                ArrayList<XmlSchema> schemas = axisService.getSchema();
                for (XmlSchema rootSchema : axisService.getSchema()) {
                    XmlSchema schema = this.getSchema(rootSchema, xsds);
                    if (schema == null) continue;
                    res.setContentType("text/xml");
                    ServletOutputStream out = res.getOutputStream();
                    schema.write((Writer)new OutputStreamWriter((OutputStream)out, "UTF8"));
                    out.flush();
                    out.close();
                    return;
                }
            }
        }
        super.processListService(req, res);
    }

    private String addContextRoot(String modifiedURL, String serviceName) {
        URI uri;
        if (!"/".equals(this.configContext.getContextRoot()) && modifiedURL.endsWith(serviceName) && !(uri = URI.create(modifiedURL)).getPath().startsWith(this.configContext.getContextRoot())) {
            modifiedURL = modifiedURL.substring(0, modifiedURL.length() - serviceName.length()) + this.configContext.getContextRoot() + serviceName;
        }
        return modifiedURL;
    }

    private XmlSchema getSchema(XmlSchema parentSchema, String name) {
        Iterator iter = parentSchema.getIncludes().getIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal extSchema = (XmlSchemaExternal)obj;
            if (extSchema.getSchemaLocation().endsWith(name)) {
                return extSchema.getSchema();
            }
            XmlSchema schema = this.getSchema(extSchema.getSchema(), name);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    private String findAxisServiceName(String path) {
        HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
        if (services == null) {
            return null;
        }
        String[] parts = path.split("/");
        String serviceName = "";
        for (int i = parts.length - 1; i >= 0; --i) {
            serviceName = parts[i] + serviceName;
            if (services.containsKey(serviceName)) {
                return serviceName;
            }
            serviceName = "/" + serviceName;
            if (!services.containsKey(serviceName)) continue;
            return serviceName;
        }
        return null;
    }

    private void setContextRoot(String filePart, String serviceName) {
        String contextRoot = this.configContext.getContextRoot();
        if (contextRoot != null && contextRoot.length() > 0) {
            if (contextRoot.equals("/")) {
                this.configContext.setServicePath("/");
            } else {
                int j;
                int i = filePart.indexOf(contextRoot) + contextRoot.length();
                if (i >= (j = filePart.lastIndexOf(serviceName)) || i + 1 == j) {
                    this.configContext.setServicePath("/");
                } else {
                    String mapping = filePart.substring(i + 1, j);
                    this.configContext.setServicePath(mapping);
                }
            }
            this.configContext.setContextRoot(contextRoot);
        }
    }

    private static String setIPAddress(String wsdlURI, String requestURI) {
        try {
            URI wsdlURIObj = new URI(wsdlURI);
            String wsdlHost = wsdlURIObj.getHost();
            int wsdlPort = wsdlURIObj.getPort();
            String wsdlAddr = wsdlHost + (wsdlPort != -1 ? ":" + Integer.toString(wsdlPort) : "");
            URI requestURIObj = new URI(requestURI);
            return wsdlURI;
        }
        catch (Exception e) {
            return wsdlURI;
        }
    }
}

