/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;
import org.oasisopen.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasAuthenticationInterceptor
implements PhasedInterceptor {
    private List<JaasAuthenticationPolicy> authenticationPolicies;
    private Invoker next;

    public JaasAuthenticationInterceptor(List<JaasAuthenticationPolicy> authenticationPolicies) {
        this.authenticationPolicies = authenticationPolicies;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        try {
            for (JaasAuthenticationPolicy policy : this.authenticationPolicies) {
                CallbackHandler callbackHandler = (CallbackHandler)policy.getCallbackHandlerClass().newInstance();
                LoginContext lc = new LoginContext(policy.getConfigurationName(), callbackHandler);
                lc.login();
            }
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        return this.getNext().invoke(msg);
    }

    public String getPhase() {
        return "implementation.policy";
    }
}

