/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.AlgorithmWrapper;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class SupportingToken
extends AbstractSecurityAssertion
implements AlgorithmWrapper,
TokenWrapper {
    private int type;
    private AlgorithmSuite algorithmSuite;
    private ArrayList tokens = new ArrayList();
    private SignedEncryptedElements signedElements;
    private SignedEncryptedElements encryptedElements;
    private SignedEncryptedParts signedParts;
    private SignedEncryptedParts encryptedParts;

    public SupportingToken(int type, int version) {
        this.type = type;
        this.setVersion(version);
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public ArrayList getTokens() {
        return this.tokens;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public int getTokenType() {
        return this.type;
    }

    public void setTokenType(int type) {
        this.type = type;
    }

    public SignedEncryptedElements getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(SignedEncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public SignedEncryptedParts getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(SignedEncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }

    public SignedEncryptedElements getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(SignedEncryptedElements signedElements) {
        this.signedElements = signedElements;
    }

    public SignedEncryptedParts getSignedParts() {
        return this.signedParts;
    }

    public void setSignedParts(SignedEncryptedParts signedParts) {
        this.signedParts = signedParts;
    }

    public void setToken(Token tok) {
        this.addToken(tok);
    }

    public QName getName() {
        switch (this.type) {
            case 1: {
                return this.version == 2 ? SP12Constants.SUPPORTING_TOKENS : SP11Constants.SUPPORTING_TOKENS;
            }
            case 3: {
                return this.version == 2 ? SP12Constants.SIGNED_SUPPORTING_TOKENS : SP11Constants.SIGNED_SUPPORTING_TOKENS;
            }
            case 2: {
                return this.version == 2 ? SP12Constants.ENDORSING_SUPPORTING_TOKENS : SP11Constants.ENDORSING_SUPPORTING_TOKENS;
            }
            case 4: {
                return this.version == 2 ? SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS : SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS;
            }
            case 6: {
                return SP12Constants.ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 5: {
                return SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 7: {
                return SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 8: {
                return SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
        }
        return null;
    }

    public boolean isEncryptedToken() {
        switch (this.type) {
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return false;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        String localname = this.getName().getLocalPart();
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        Iterator iterator = this.getTokens().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            token.serialize(writer);
        }
        if (this.signedParts != null) {
            this.signedParts.serialize(writer);
        } else if (this.signedElements != null) {
            this.signedElements.serialize(writer);
        } else if (this.encryptedParts != null) {
            this.encryptedParts.serialize(writer);
        } else if (this.encryptedElements != null) {
            this.encryptedElements.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

