/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.AsymmetricBinding;
import org.apache.ws.secpolicy.model.InitiatorToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.RecipientToken;

public class AsymmetricBindingBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        AsymmetricBinding asymmetricBinding = new AsymmetricBinding(2);
        Policy policy = PolicyEngine.getPolicy(element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), asymmetricBinding);
        }
        return asymmetricBinding;
    }

    private void processAlternative(List assertions, AsymmetricBinding asymmetricBinding) {
        Iterator iterator = assertions.iterator();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            QName name = assertion.getName();
            if (SP12Constants.INITIATOR_TOKEN.equals(name)) {
                asymmetricBinding.setInitiatorToken((InitiatorToken)assertion);
                continue;
            }
            if (SP12Constants.RECIPIENT_TOKEN.equals(name)) {
                asymmetricBinding.setRecipientToken((RecipientToken)assertion);
                continue;
            }
            if (SP12Constants.ALGORITHM_SUITE.equals(name)) {
                asymmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if (SP12Constants.LAYOUT.equals(name)) {
                asymmetricBinding.setLayout((Layout)assertion);
                continue;
            }
            if (SP12Constants.INCLUDE_TIMESTAMP.equals(name)) {
                asymmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if (SP12Constants.ENCRYPT_BEFORE_SIGNING.equals(name)) {
                asymmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                continue;
            }
            if (SP12Constants.SIGN_BEFORE_ENCRYPTING.equals(name)) {
                asymmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                continue;
            }
            if (SP12Constants.ENCRYPT_SIGNATURE.equals(name)) {
                asymmetricBinding.setSignatureProtection(true);
                continue;
            }
            if (SP12Constants.PROTECT_TOKENS.equals(name)) {
                asymmetricBinding.setTokenProtection(true);
                continue;
            }
            if (!"OnlySignEntireHeadersAndBody".equals(name.getLocalPart())) continue;
            asymmetricBinding.setEntireHeadersAndBodySignatures(true);
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.ASYMMETRIC_BINDING};
    }
}

