/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.Loader;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transform;

public class WSSConfig {
    private static final Map DEFAULT_ACTIONS;
    private static final Map DEFAULT_PROCESSORS;
    private static Log log;
    protected static WSSConfig defaultConfig;
    protected boolean wsiBSPCompliant = false;
    protected boolean precisionInMilliSeconds = true;
    protected boolean enableSignatureConfirmation = true;
    protected boolean timeStampStrict = true;
    protected boolean handleCustomPasswordTypes = false;
    protected HashMap jceProvider = new HashMap(10);
    private final Map actionMap = new HashMap(DEFAULT_ACTIONS);
    private final Map processorMap = new HashMap(DEFAULT_PROCESSORS);
    private static boolean addJceProviders;
    private static boolean staticallyInitialized;
    static /* synthetic */ Class class$org$apache$ws$security$action$UsernameTokenAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$EncryptionAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$SignatureAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$SAMLTokenSignedAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$SAMLTokenUnsignedAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$TimestampAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$UsernameTokenSignedAction;
    static /* synthetic */ Class class$org$apache$ws$security$action$SignatureConfirmationAction;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SAMLTokenProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$EncryptedKeyProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SignatureProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$TimestampProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$UsernameTokenProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$ReferenceListProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SignatureConfirmationProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$DerivedKeyTokenProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SecurityContextTokenProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$BinarySecurityTokenProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$processor$EncryptedDataProcessor;
    static /* synthetic */ Class class$org$apache$ws$security$WSSConfig;

    public static void setAddJceProviders(boolean value) {
        addJceProviders = value;
    }

    private synchronized void staticInit() {
        if (!staticallyInitialized) {
            Init.init();
            if (addJceProviders) {
                this.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
                this.addJceProvider("JuiCE", "org.apache.security.juice.provider.JuiCEProviderOpenSSL");
            }
            Transform.init();
            try {
                Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "org.apache.ws.security.transform.STRTransform");
            }
            catch (Exception exception) {
                // empty catch block
            }
            staticallyInitialized = true;
        }
    }

    protected WSSConfig() {
        this.staticInit();
    }

    public static WSSConfig getNewInstance() {
        WSSConfig config = new WSSConfig();
        return config;
    }

    public static WSSConfig getDefaultWSConfig() {
        if (defaultConfig == null) {
            defaultConfig = WSSConfig.getNewInstance();
        }
        return defaultConfig;
    }

    public boolean isWsiBSPCompliant() {
        return this.wsiBSPCompliant;
    }

    public void setWsiBSPCompliant(boolean wsiBSPCompliant) {
        this.wsiBSPCompliant = wsiBSPCompliant;
    }

    public boolean isPrecisionInMilliSeconds() {
        return this.precisionInMilliSeconds;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.precisionInMilliSeconds = precisionInMilliSeconds;
    }

    public boolean isEnableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setHandleCustomPasswordTypes(boolean handleCustomTypes) {
        this.handleCustomPasswordTypes = handleCustomTypes;
    }

    public boolean getHandleCustomPasswordTypes() {
        return this.handleCustomPasswordTypes;
    }

    public boolean isTimeStampStrict() {
        return this.timeStampStrict;
    }

    public void setTimeStampStrict(boolean timeStampStrict) {
        this.timeStampStrict = timeStampStrict;
    }

    public String setAction(int code, String action) {
        return this.actionMap.put(new Integer(code), action);
    }

    public Action getAction(int action) throws WSSecurityException {
        Integer key = new Integer(action);
        String name = (String)this.actionMap.get(key);
        if (name == null) {
            throw new WSSecurityException(0, "unknownAction", new Object[]{key});
        }
        try {
            return (Action)Loader.loadClass(name).newInstance();
        }
        catch (Throwable t) {
            throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name});
        }
    }

    public String setProcessor(QName el, String name) {
        return this.processorMap.put(el, name);
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        String name = (String)this.processorMap.get(el);
        if (name != null) {
            try {
                return (Processor)Loader.loadClass(name).newInstance();
            }
            catch (Throwable t) {
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name});
            }
        }
        return null;
    }

    private boolean loadProvider(String id, String className) {
        try {
            Class c = Loader.loadClass(className);
            if (Security.getProvider(id) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The provider " + id + " had to be added to the java.security.Security"));
                }
                int ret = Security.insertProviderAt((Provider)c.newInstance(), 2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The provider " + id + " was added at: " + ret));
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The provider " + id + " could not be added: " + t.getMessage()));
            }
            return false;
        }
    }

    public boolean addJceProvider(String id, String className) {
        if (this.jceProvider.get(id) == null && this.loadProvider(id, className)) {
            this.jceProvider.put(id, className);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<Serializable, String> tmp = new HashMap<Serializable, String>();
        try {
            tmp.put(new Integer(1), (class$org$apache$ws$security$action$UsernameTokenAction == null ? (class$org$apache$ws$security$action$UsernameTokenAction = WSSConfig.class$("org.apache.ws.security.action.UsernameTokenAction")) : class$org$apache$ws$security$action$UsernameTokenAction).getName());
            tmp.put(new Integer(4), (class$org$apache$ws$security$action$EncryptionAction == null ? (class$org$apache$ws$security$action$EncryptionAction = WSSConfig.class$("org.apache.ws.security.action.EncryptionAction")) : class$org$apache$ws$security$action$EncryptionAction).getName());
            tmp.put(new Integer(2), (class$org$apache$ws$security$action$SignatureAction == null ? (class$org$apache$ws$security$action$SignatureAction = WSSConfig.class$("org.apache.ws.security.action.SignatureAction")) : class$org$apache$ws$security$action$SignatureAction).getName());
            tmp.put(new Integer(16), (class$org$apache$ws$security$action$SAMLTokenSignedAction == null ? (class$org$apache$ws$security$action$SAMLTokenSignedAction = WSSConfig.class$("org.apache.ws.security.action.SAMLTokenSignedAction")) : class$org$apache$ws$security$action$SAMLTokenSignedAction).getName());
            tmp.put(new Integer(8), (class$org$apache$ws$security$action$SAMLTokenUnsignedAction == null ? (class$org$apache$ws$security$action$SAMLTokenUnsignedAction = WSSConfig.class$("org.apache.ws.security.action.SAMLTokenUnsignedAction")) : class$org$apache$ws$security$action$SAMLTokenUnsignedAction).getName());
            tmp.put(new Integer(32), (class$org$apache$ws$security$action$TimestampAction == null ? (class$org$apache$ws$security$action$TimestampAction = WSSConfig.class$("org.apache.ws.security.action.TimestampAction")) : class$org$apache$ws$security$action$TimestampAction).getName());
            tmp.put(new Integer(64), (class$org$apache$ws$security$action$UsernameTokenSignedAction == null ? (class$org$apache$ws$security$action$UsernameTokenSignedAction = WSSConfig.class$("org.apache.ws.security.action.UsernameTokenSignedAction")) : class$org$apache$ws$security$action$UsernameTokenSignedAction).getName());
            tmp.put(new Integer(128), (class$org$apache$ws$security$action$SignatureConfirmationAction == null ? (class$org$apache$ws$security$action$SignatureConfirmationAction = WSSConfig.class$("org.apache.ws.security.action.SignatureConfirmationAction")) : class$org$apache$ws$security$action$SignatureConfirmationAction).getName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        DEFAULT_ACTIONS = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        try {
            tmp.put(WSSecurityEngine.SAML_TOKEN, (class$org$apache$ws$security$processor$SAMLTokenProcessor == null ? (class$org$apache$ws$security$processor$SAMLTokenProcessor = WSSConfig.class$("org.apache.ws.security.processor.SAMLTokenProcessor")) : class$org$apache$ws$security$processor$SAMLTokenProcessor).getName());
            tmp.put(WSSecurityEngine.ENCRYPTED_KEY, (class$org$apache$ws$security$processor$EncryptedKeyProcessor == null ? (class$org$apache$ws$security$processor$EncryptedKeyProcessor = WSSConfig.class$("org.apache.ws.security.processor.EncryptedKeyProcessor")) : class$org$apache$ws$security$processor$EncryptedKeyProcessor).getName());
            tmp.put(WSSecurityEngine.SIGNATURE, (class$org$apache$ws$security$processor$SignatureProcessor == null ? (class$org$apache$ws$security$processor$SignatureProcessor = WSSConfig.class$("org.apache.ws.security.processor.SignatureProcessor")) : class$org$apache$ws$security$processor$SignatureProcessor).getName());
            tmp.put(WSSecurityEngine.timeStamp, (class$org$apache$ws$security$processor$TimestampProcessor == null ? (class$org$apache$ws$security$processor$TimestampProcessor = WSSConfig.class$("org.apache.ws.security.processor.TimestampProcessor")) : class$org$apache$ws$security$processor$TimestampProcessor).getName());
            tmp.put(WSSecurityEngine.usernameToken, (class$org$apache$ws$security$processor$UsernameTokenProcessor == null ? (class$org$apache$ws$security$processor$UsernameTokenProcessor = WSSConfig.class$("org.apache.ws.security.processor.UsernameTokenProcessor")) : class$org$apache$ws$security$processor$UsernameTokenProcessor).getName());
            tmp.put(WSSecurityEngine.REFERENCE_LIST, (class$org$apache$ws$security$processor$ReferenceListProcessor == null ? (class$org$apache$ws$security$processor$ReferenceListProcessor = WSSConfig.class$("org.apache.ws.security.processor.ReferenceListProcessor")) : class$org$apache$ws$security$processor$ReferenceListProcessor).getName());
            tmp.put(WSSecurityEngine.signatureConfirmation, (class$org$apache$ws$security$processor$SignatureConfirmationProcessor == null ? (class$org$apache$ws$security$processor$SignatureConfirmationProcessor = WSSConfig.class$("org.apache.ws.security.processor.SignatureConfirmationProcessor")) : class$org$apache$ws$security$processor$SignatureConfirmationProcessor).getName());
            tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02, (class$org$apache$ws$security$processor$DerivedKeyTokenProcessor == null ? (class$org$apache$ws$security$processor$DerivedKeyTokenProcessor = WSSConfig.class$("org.apache.ws.security.processor.DerivedKeyTokenProcessor")) : class$org$apache$ws$security$processor$DerivedKeyTokenProcessor).getName());
            tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12, (String)tmp.get(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02));
            tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02, (class$org$apache$ws$security$processor$SecurityContextTokenProcessor == null ? (class$org$apache$ws$security$processor$SecurityContextTokenProcessor = WSSConfig.class$("org.apache.ws.security.processor.SecurityContextTokenProcessor")) : class$org$apache$ws$security$processor$SecurityContextTokenProcessor).getName());
            tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12, (String)tmp.get(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02));
            tmp.put(WSSecurityEngine.binaryToken, (class$org$apache$ws$security$processor$BinarySecurityTokenProcessor == null ? (class$org$apache$ws$security$processor$BinarySecurityTokenProcessor = WSSConfig.class$("org.apache.ws.security.processor.BinarySecurityTokenProcessor")) : class$org$apache$ws$security$processor$BinarySecurityTokenProcessor).getName());
            tmp.put(WSSecurityEngine.ENCRYPTED_DATA, (class$org$apache$ws$security$processor$EncryptedDataProcessor == null ? (class$org$apache$ws$security$processor$EncryptedDataProcessor = WSSConfig.class$("org.apache.ws.security.processor.EncryptedDataProcessor")) : class$org$apache$ws$security$processor$EncryptedDataProcessor).getName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        DEFAULT_PROCESSORS = Collections.unmodifiableMap(tmp);
        log = LogFactory.getLog((String)(class$org$apache$ws$security$WSSConfig == null ? (class$org$apache$ws$security$WSSConfig = WSSConfig.class$("org.apache.ws.security.WSSConfig")) : class$org$apache$ws$security$WSSConfig).getName());
        defaultConfig = null;
        addJceProviders = true;
        staticallyInitialized = false;
    }
}

