/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSecDerivedKeyBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSecDKSign
extends WSSecDerivedKeyBase {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSSecDKSign == null ? (class$org$apache$ws$security$message$WSSecDKSign = WSSecDKSign.class$("org.apache.ws.security.message.WSSecDKSign")) : class$org$apache$ws$security$message$WSSecDKSign).getName());
    protected String sigAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected byte[] signatureValue = null;
    private XMLSignature sig = null;
    private KeyInfo keyInfo = null;
    private String keyInfoUri = null;
    private SecurityTokenReference secRef = null;
    private String strUri = null;
    private WSDocInfo wsDocInfo;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSecDKSign;

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        this.prepare(doc, secHeader);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        this.addReferencesToSign(this.parts, secHeader);
        this.computeSignature();
        this.prependSigToHeader(secHeader);
        this.prependDKElementToHeader(secHeader);
        return doc;
    }

    public void prepare(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        super.prepare(doc);
        this.wsDocInfo = new WSDocInfo(doc.hashCode());
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace(doc, "CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, this.sigAlgo);
                this.sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error((Object)"", (Throwable)e);
                throw new WSSecurityException(10, "noXMLSig");
            }
        }
        try {
            this.sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new WSSecurityException(10, "noXMLSig");
        }
        this.sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        String sigUri = "Signature-" + this.sig.hashCode();
        this.sig.setId(sigUri);
        this.keyInfo = this.sig.getKeyInfo();
        this.keyInfoUri = "KeyId-" + this.keyInfo.hashCode();
        this.keyInfo.setId(this.keyInfoUri);
        this.secRef = new SecurityTokenReference(doc);
        this.strUri = "STRId-" + this.secRef.hashCode();
        this.secRef.setID(this.strUri);
        Reference refUt = new Reference(this.document);
        refUt.setURI("#" + this.dktId);
        this.secRef.setReference(refUt);
        this.keyInfo.addUnknownElement(this.secRef.getElement());
    }

    protected Set getInclusivePrefixes(Element target) {
        return this.getInclusivePrefixes(target, true);
    }

    protected Set getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        HashSet<String> result = new HashSet<String>();
        Node parent = target;
        while (!(parent.getParentNode() instanceof Document)) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                if (attribute.getNodeName().equals("xmlns")) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    if (attribute.getNodeName().equals("xmlns")) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    public void addReferencesToSign(Vector references, WSSecHeader secHeader) throws WSSecurityException {
        Transforms transforms = null;
        Element envel = this.document.getDocumentElement();
        for (int part = 0; part < references.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToSign = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            transforms = new Transforms(this.document);
            try {
                if (idToSign != null) {
                    Element toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    if (toSignById == null) {
                        toSignById = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToSign, null);
                    }
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(toSignById)).getElement());
                    }
                    this.sig.addDocument("#" + idToSign, transforms);
                    continue;
                }
                if (elemName.equals("Token")) {
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(this.keyInfo.getElement())).getElement());
                    }
                    this.sig.addDocument("#" + this.keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(this.document);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    this.sig.addDocument("#" + this.strUri, transforms);
                    continue;
                }
                if (elemName.equals("Assertion")) {
                    String id = null;
                    id = SAMLUtil.getAssertionId(envel, elemName, nmSpace);
                    Element body = (Element)WSSecurityUtil.findElement(envel, elemName, nmSpace);
                    if (body == null) {
                        throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                    }
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(body)).getElement());
                    }
                    String prefix = WSSecurityUtil.setNamespace(body, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    body.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
                    this.sig.addDocument("#" + id, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envel, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (this.wssConfig.isWsiBSPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.document, this.getInclusivePrefixes(body)).getElement());
                }
                this.sig.addDocument("#" + this.setWsuId(body), transforms);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
        }
    }

    protected Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
        WSSecurityUtil.setNamespace(transformParam, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        WSSecurityUtil.setNamespace(canonElem, "http://www.w3.org/2000/09/xmldsig#", "ds");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }

    public void prependSigToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.sig.getElement(), false);
    }

    public void appendSigToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.appendChildElement(this.document, secHeader.getSecurityHeader(), this.sig.getElement());
    }

    public Element getSignatureElement() {
        return this.sig.getElement();
    }

    public void computeSignature() throws WSSecurityException {
        WSDocInfoStore.store(this.wsDocInfo);
        try {
            this.sig.sign(this.sig.createSecretKey(this.derivedKeyBytes));
            this.signatureValue = this.sig.getSignatureValue();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(this.wsDocInfo);
        }
    }

    protected int getDerivedKeyLength() throws WSSecurityException {
        return this.derivedKeyLength > 0 ? this.derivedKeyLength : WSSecurityUtil.getKeyLength(this.sigAlgo);
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigAlgo = algo;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

