/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jam.internal.elements;

import java.io.StringWriter;
import java.lang.reflect.Modifier;
import org.codehaus.jam.JClass;
import org.codehaus.jam.internal.classrefs.DirectJClassRef;
import org.codehaus.jam.internal.classrefs.JClassRef;
import org.codehaus.jam.internal.classrefs.QualifiedJClassRef;
import org.codehaus.jam.internal.classrefs.UnqualifiedJClassRef;
import org.codehaus.jam.internal.elements.ClassImpl;
import org.codehaus.jam.internal.elements.MemberImpl;
import org.codehaus.jam.mutable.MField;
import org.codehaus.jam.visitor.JVisitor;
import org.codehaus.jam.visitor.MVisitor;

public final class FieldImpl
extends MemberImpl
implements MField {
    private JClassRef mTypeClassRef;

    FieldImpl(String simpleName, ClassImpl containingClass, String qualifiedTypeClassName) {
        super(containingClass);
        super.setSimpleName(simpleName);
        this.mTypeClassRef = QualifiedJClassRef.create(qualifiedTypeClassName, containingClass);
    }

    public void setType(JClass type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.mTypeClassRef = DirectJClassRef.create(type);
    }

    public void setType(String qcname) {
        if (qcname == null) {
            throw new IllegalArgumentException("null qcname");
        }
        this.mTypeClassRef = QualifiedJClassRef.create(qcname, (ClassImpl)this.getContainingClass());
    }

    public void setUnqualifiedType(String ucname) {
        if (ucname == null) {
            throw new IllegalArgumentException("null ucname");
        }
        this.mTypeClassRef = UnqualifiedJClassRef.create(ucname, (ClassImpl)this.getContainingClass());
    }

    public JClass getType() {
        if (this.mTypeClassRef == null) {
            throw new IllegalStateException();
        }
        return this.mTypeClassRef.getRefClass();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    public void accept(MVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(JVisitor visitor) {
        visitor.visit(this);
    }

    public String getQualifiedName() {
        StringWriter sbuf = new StringWriter();
        sbuf.write(Modifier.toString(this.getModifiers()));
        sbuf.write(32);
        sbuf.write(this.getType().getQualifiedName());
        sbuf.write(32);
        sbuf.write(this.getContainingClass().getQualifiedName());
        sbuf.write(46);
        sbuf.write(this.getSimpleName());
        return sbuf.toString();
    }
}

