/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPServiceListenerServlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class HTTPServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponentService service;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private ServletHost servletHost;
    private String servletMapping;
    private HTTPBindingListenerServlet bindingListenerServlet;

    public HTTPServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, HTTPBinding binding, MessageFactory messageFactory, ServletHost servletHost) {
        this.service = service;
        this.binding = binding;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
    }

    public void start() {
        RuntimeComponentService componentService = this.service;
        RuntimeWire wire = componentService.getRuntimeWire((Binding)this.binding);
        Object servlet = null;
        this.bindingListenerServlet = new HTTPBindingListenerServlet((Binding)this.binding, this.messageFactory);
        for (InvocationChain invocationChain : wire.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("get")) {
                Invoker getInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setGetInvoker(getInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalGet")) {
                Invoker conditionalGetInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalGetInvoker(conditionalGetInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("delete")) {
                Invoker deleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setDeleteInvoker(deleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalDelete")) {
                Invoker conditionalDeleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalDeleteInvoker(conditionalDeleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("put")) {
                Invoker putInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPutInvoker(putInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPut")) {
                Invoker conditionalPutInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPutInvoker(conditionalPutInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("post")) {
                Invoker postInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPostInvoker(postInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPost")) {
                Invoker conditionalPostInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPostInvoker(conditionalPostInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (!operationName.equals("service")) continue;
            Invoker serviceInvoker = invocationChain.getHeadInvoker();
            servlet = new HTTPServiceListenerServlet((Binding)this.binding, serviceInvoker, this.messageFactory);
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, servlet);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return null;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

