/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.axis2.impl;

import java.util.List;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.sca.DistributedSCABinding;
import org.apache.tuscany.sca.binding.sca.axis2.impl.Axis2SCAServiceProvider;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceProvider;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.work.WorkScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2SCAServiceBindingProvider
implements ServiceBindingProvider {
    private static final Logger logger = Logger.getLogger(Axis2SCAServiceBindingProvider.class.getName());
    private SCABinding binding;
    private Axis2ServiceProvider axisProvider;
    private WebServiceBinding wsBinding;
    private boolean started = false;

    public Axis2SCAServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, DistributedSCABinding binding, ExtensionPointRegistry extensionPoints, List<PolicyHandlerTuple> policyHandlerClassnames) {
        ServletHostExtensionPoint servletHosts = (ServletHostExtensionPoint)extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        ServletHost servletHost = (ServletHost)servletHosts.getServletHosts().get(0);
        ModelFactoryExtensionPoint modelFactories = (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        MessageFactory messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        DataBindingExtensionPoint dataBindings = (DataBindingExtensionPoint)extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        WorkScheduler workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
        this.binding = binding.getSCABinding();
        this.wsBinding = ((WebServiceBindingFactory)modelFactories.getFactory(WebServiceBindingFactory.class)).createWebServiceBinding();
        this.wsBinding.setName(this.binding.getName());
        this.wsBinding.setURI(this.binding.getURI());
        BindingWSDLGenerator.generateWSDL((Component)component, (AbstractContract)service, (WebServiceBinding)this.wsBinding, (ExtensionPointRegistry)extensionPoints, null);
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        contract.getInterface().resetDataBinding(OMElement.class.getName());
        this.axisProvider = new Axis2SCAServiceProvider(component, service, this.binding, this.wsBinding, servletHost, messageFactory, policyHandlerClassnames, workScheduler);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.axisProvider.start();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.axisProvider.stop();
    }
}

