/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.basic;

import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;
import org.apache.tuscany.sca.policy.security.SecurityUtil;
import org.oasisopen.sca.ServiceRuntimeException;

public class BasicAuthenticationReferencePolicyInterceptor
implements PhasedInterceptor {
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    public static final QName policySetQName = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "wsBasicAuthentication");
    private Invoker next;
    private PolicySet policySet = null;
    private String context;
    private BasicAuthenticationPolicy policy;

    public BasicAuthenticationReferencePolicyInterceptor(String context, PolicySet policySet) {
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (PolicyExpression policyExpression : this.policySet.getPolicies()) {
                if (!(policyExpression.getPolicy() instanceof BasicAuthenticationPolicy)) continue;
                this.policy = (BasicAuthenticationPolicy)policyExpression.getPolicy();
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        OperationClient operationClient = (OperationClient)msg.getBindingContext();
        String username = null;
        String password = null;
        Subject subject = SecurityUtil.getSubject((Message)msg);
        BasicAuthenticationPrincipal principal = (BasicAuthenticationPrincipal)SecurityUtil.getPrincipal((Subject)subject, BasicAuthenticationPrincipal.class);
        if (principal != null) {
            username = principal.getName();
            password = principal.getPassword();
        } else if (this.policy != null) {
            username = this.policy.getUserName();
            password = this.policy.getPassword();
            principal = new BasicAuthenticationPrincipal(username, password);
            subject.getPrincipals().add((Principal)principal);
        }
        if (username == null || password == null) {
            throw new ServiceRuntimeException("Basic authentication username and/or password is null");
        }
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        ArrayList<String> auth = new ArrayList<String>();
        auth.add("Basic");
        authenticator.setAuthSchemes(auth);
        authenticator.setPreemptiveAuthentication(true);
        authenticator.setUsername(username);
        authenticator.setPassword(password);
        operationClient.getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public String getPhase() {
        return "reference.binding.policy";
    }
}

