/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<String, Artifact> map = new HashMap<String, Artifact>();

    public ArtifactModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    public void addModel(Object resolved) {
        Artifact artifact = (Artifact)resolved;
        this.map.put(artifact.getURI(), artifact);
    }

    public Object removeModel(Object resolved) {
        return this.map.remove(((Artifact)resolved).getURI());
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        String uri = ((Artifact)unresolved).getURI();
        if (uri == null) {
            return unresolved;
        }
        Artifact resolved = this.map.get(uri);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            ResourceImport resourceImport;
            if (!(import_ instanceof ResourceImport) || !(resourceImport = (ResourceImport)import_).getURI().equals(uri) || resourceImport.getModelResolver() == null || (resolved = (Artifact)resourceImport.getModelResolver().resolveModel(Artifact.class, (Object)((Artifact)unresolved))).isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        return unresolved;
    }
}

