/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceExport;
import org.apache.tuscany.sca.contribution.resource.ResourceImportExportFactory;
import org.apache.tuscany.sca.contribution.resource.impl.ResourceExportModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ResourceExportProcessor
implements StAXArtifactProcessor<ResourceExport> {
    private static final String URI = "uri";
    private final ResourceImportExportFactory factory;

    public ResourceExportProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = (ResourceImportExportFactory)modelFactories.getFactory(ResourceImportExportFactory.class);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-resource-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return ResourceExport.TYPE;
    }

    public Class<ResourceExport> getModelType() {
        return ResourceExport.class;
    }

    public ResourceExport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        ResourceExport resourceExport = this.factory.createResourceExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!ResourceExport.TYPE.equals(element)) break;
                        String uri = reader.getAttributeValue(null, URI);
                        if (uri == null) {
                            this.error(context.getMonitor(), "AttributeURIMissing", reader, new Object[0]);
                            break;
                        }
                        resourceExport.setURI(uri);
                        break;
                    }
                    case 2: {
                        if (!ResourceExport.TYPE.equals(reader.getName())) break;
                        return resourceExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return resourceExport;
    }

    public void write(ResourceExport resourceExport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(ResourceExport.TYPE.getNamespaceURI(), ResourceExport.TYPE.getLocalPart());
        if (resourceExport.getURI() != null) {
            writer.writeAttribute(URI, resourceExport.getURI());
        }
        writer.writeEndElement();
    }

    public void resolve(ResourceExport resourceExport, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (resourceExport.getURI() != null) {
            resourceExport.setModelResolver(new ResourceExportModelResolver(resourceExport, resolver));
        }
    }
}

