/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.node;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.domain.node.ConfigAttributesImpl;
import org.apache.tuscany.sca.management.ConfigAttributes;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;

public class DomainNode {
    public static final String DOMAIN_NAME_ATTR = "domainName";
    public static final String DOMAIN_SCHEME_ATTR = "domainScheme";
    public static final String DEFAULT_DOMAIN_SCHEME = "vm";
    public static final String DEFAULT_DOMAIN_NAME = "defaultDomain";
    private ConfigAttributes configAttributes = new ConfigAttributesImpl();
    private String domainRegistryURI;
    private NodeFactory nodeFactory;
    private Map<String, Node> nodes = new HashMap<String, Node>();

    public DomainNode() {
        this("vm://defaultDomain");
    }

    public DomainNode(String configURI) {
        this.domainRegistryURI = configURI;
        this.parseConfigURI(configURI);
        this.start();
    }

    public DomainNode(String configURI, String ... contributionLocations) {
        this.domainRegistryURI = configURI;
        this.parseConfigURI(configURI);
        this.start();
        String[] stringArray = contributionLocations;
        int n = contributionLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String loc = stringArray[n2];
            this.addContribution(loc);
            ++n2;
        }
    }

    public void start() {
        if (this.nodeFactory != null) {
            throw new IllegalStateException("The node is already started");
        }
        this.nodeFactory = NodeFactory.getInstance((String)((String)this.configAttributes.getAttributes().get(DOMAIN_NAME_ATTR)));
    }

    public boolean isStarted() {
        return this.nodeFactory != null;
    }

    public void stop() {
        if (this.nodeFactory == null) {
            throw new IllegalStateException("The node is not started");
        }
        for (Node node : this.nodes.values()) {
            node.stop();
        }
    }

    public String addContribution(String location) {
        String uri = location;
        this.addContribution(uri, location);
        return uri;
    }

    public void addContribution(String location, String uri) {
        if (this.nodes.containsKey(uri)) {
            throw new IllegalArgumentException("contribution already added: " + uri);
        }
        NodeConfiguration configuration = this.nodeFactory.createNodeConfiguration().addContribution(uri, location).setDomainRegistryURI(this.domainRegistryURI).setDomainURI((String)this.configAttributes.getAttributes().get(DOMAIN_NAME_ATTR)).setURI(uri);
        Node node = this.nodeFactory.createNode(configuration).start();
        this.nodes.put(uri, node);
    }

    public void removeContribution(String uri) {
        if (!this.nodes.containsKey(uri)) {
            throw new IllegalArgumentException("contribution not found: " + uri);
        }
        Node node = this.nodes.remove(uri);
        node.stop();
    }

    public ConfigAttributes getConfigAttributes() {
        return this.configAttributes;
    }

    public String getDomainName() {
        return (String)this.configAttributes.getAttributes().get(DOMAIN_NAME_ATTR);
    }

    protected void parseConfigURI(String configURI) {
        String query;
        URI uri = URI.create(this.fixScheme(configURI));
        String dn = uri.getHost();
        if (dn == null || dn.length() < 1) {
            dn = DEFAULT_DOMAIN_NAME;
        }
        this.configAttributes.getAttributes().put(DOMAIN_NAME_ATTR, dn);
        String scheme = uri.getScheme();
        if (scheme != null && scheme.length() > 0) {
            this.configAttributes.getAttributes().put(DOMAIN_SCHEME_ATTR, scheme);
        }
        if ((query = uri.getQuery()) != null && query.length() > 0) {
            String[] params;
            String[] stringArray = params = query.split("&");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String name = param.split("=")[0];
                String value = param.split("=")[1];
                this.configAttributes.getAttributes().put(name, value);
                ++n2;
            }
        }
    }

    private String fixScheme(String uri) {
        int i = uri.indexOf(":");
        if (i > -1 && uri.charAt(i + 1) != '/') {
            uri = uri.replaceFirst(":", ":/");
        }
        if (i > -1 && uri.charAt(i + 2) != '/') {
            uri = uri.replaceFirst(":/", "://");
        }
        return uri;
    }
}

