/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistryLocator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.runtime.ActiveNodes;

public class RemoteCommand
implements Callable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String domainName;
    private String command;
    private String contributionURI;
    private String compositeURI;

    public RemoteCommand(String domainName, String command, String contributionURI, String compositeURI) {
        this.domainName = domainName;
        this.command = command;
        this.contributionURI = contributionURI;
        this.compositeURI = compositeURI;
    }

    @Override
    public String call() throws Exception {
        String response;
        try {
            Node node = this.getNode();
            if ("start".equals(this.command)) {
                node.startComposite(this.contributionURI, this.compositeURI);
                response = "Started.";
            } else if ("stop".equals(this.command)) {
                node.stopComposite(this.contributionURI, this.compositeURI);
                response = "Stopped.";
            } else {
                response = "Unknown command: " + this.command;
            }
        }
        catch (Exception e) {
            response = "REMOTE EXCEPTION: " + e.getClass() + ":" + e.getMessage();
        }
        return response;
    }

    private Node getNode() {
        for (ExtensionPointRegistry xpr : ExtensionPointRegistryLocator.getExtensionPointRegistries()) {
            ActiveNodes activeNodes = (ActiveNodes)((UtilityExtensionPoint)xpr.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(ActiveNodes.class);
            for (Object o : activeNodes.getActiveNodes()) {
                Node node = (Node)o;
                if (!node.getDomainName().equals(this.domainName)) continue;
                return node;
            }
        }
        throw new IllegalStateException("No remote Node found for domain: " + this.domainName);
    }
}

