/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.ReplicatedMap;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedEndpointRegistry
implements EndpointRegistry {
    private static final Logger logger = Logger.getLogger(ReplicatedEndpointRegistry.class.getName());
    private static final String MULTICAST_ADDRESS = "228.0.0.100";
    private static final int MULTICAST_PORT = 50000;
    private int port = 50000;
    private String address = "228.0.0.100";
    private String bind = null;
    private int timeout = 50;
    private static final String DEFAULT_DOMAIN_URI = "http://tuscany.apache.org/sca/1.1/domains/default";
    private String domainURI = "http://tuscany.apache.org/sca/1.1/domains/default";
    private List<EndpointReference> endpointreferences = new CopyOnWriteArrayList<EndpointReference>();
    private List<EndpointListener> listeners = new CopyOnWriteArrayList<EndpointListener>();
    private ExtensionPointRegistry registry;
    private ReplicatedMap map;

    private static final Channel createChannel(String address, int port, String bindAddress) {
        GroupChannel channel = new GroupChannel();
        McastService mcastService = (McastService)channel.getMembershipService();
        mcastService.setPort(port);
        mcastService.setAddress(address);
        if (bindAddress != null) {
            mcastService.setBind(bindAddress);
        }
        return channel;
    }

    public ReplicatedEndpointRegistry(ExtensionPointRegistry registry, Map<String, String> attributes) {
        String address;
        this.registry = registry;
        String portStr = attributes.get("port");
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
        }
        if ((address = attributes.get("address")) == null) {
            address = MULTICAST_ADDRESS;
        }
        this.bind = attributes.get("bind");
        String timeoutStr = attributes.get("timeout");
        if (timeoutStr != null) {
            this.timeout = Integer.parseInt(timeoutStr);
        }
        this.start();
    }

    public ReplicatedEndpointRegistry(String domainURI) {
        this.domainURI = domainURI;
        this.start();
    }

    public void start() {
        this.map = new ReplicatedMap(null, ReplicatedEndpointRegistry.createChannel(this.address, this.port, this.bind), (long)this.timeout, this.domainURI, new ClassLoader[]{ReplicatedEndpointRegistry.class.getClassLoader()});
        try {
            this.map.getChannel().start(15);
        }
        catch (ChannelException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() {
        Channel channel = this.map.getChannel();
        this.map.breakdown();
        try {
            channel.stop(15);
        }
        catch (ChannelException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addEndpoint(Endpoint endpoint) {
        this.map.put((Object)endpoint.getURI(), (Object)endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(endpoint);
        }
        logger.info("EndpointRegistry: Add endpoint - " + endpoint);
    }

    public void addEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.add(endpointReference);
        logger.info("EndpointRegistry: Add endpoint reference - " + endpointReference);
    }

    public void addListener(EndpointListener listener) {
        this.listeners.add(listener);
    }

    private String[] parse(String uri) {
        String[] names = new String[3];
        int index = uri.lastIndexOf(35);
        if (index == -1) {
            names[0] = uri;
        } else {
            names[0] = uri.substring(0, index);
            String str = uri.substring(index + 1);
            if (str.startsWith("service-binding(") && str.endsWith(")")) {
                String[] parts = (str = str.substring("service-binding(".length(), str.length() - 1)).split("/");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid service-binding URI: " + uri);
                }
                names[1] = parts[0];
                names[2] = parts[1];
            } else if (str.startsWith("service(") && str.endsWith(")")) {
                names[1] = str = str.substring("service(".length(), str.length() - 1);
            } else {
                throw new IllegalArgumentException("Invalid component/service/binding URI: " + uri);
            }
        }
        return names;
    }

    private boolean matches(String target, String uri) {
        String[] parts1 = this.parse(target);
        String[] parts2 = this.parse(uri);
        int i = 0;
        while (i < parts1.length) {
            if (parts1[i] != null && !parts1[i].equals(parts2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<Endpoint> findEndpoint(EndpointReference endpointReference) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        logger.info("EndpointRegistry: Find endpoint for reference - " + endpointReference);
        if (endpointReference.getReference() != null) {
            Endpoint targetEndpoint = endpointReference.getTargetEndpoint();
            for (Object v : this.map.values()) {
                Endpoint endpoint = (Endpoint)v;
                if (!this.matches(targetEndpoint.getURI(), endpoint.getURI())) continue;
                AbstractReplicatedMap.MapEntry entry = this.map.getInternal((Object)endpoint.getURI());
                if (!entry.isPrimary()) {
                    endpoint.setExtensionPointRegistry(this.registry);
                }
                foundEndpoints.add(endpoint);
                logger.info("EndpointRegistry: Found endpoint with matching service  - " + endpoint);
            }
        }
        return foundEndpoints;
    }

    public List<EndpointReference> findEndpointReference(Endpoint endpoint) {
        return this.endpointreferences;
    }

    public Endpoint getEndpoint(String uri) {
        return (Endpoint)this.map.get((Object)uri);
    }

    public List<EndpointReference> getEndpointRefereneces() {
        return this.endpointreferences;
    }

    public List<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.map.values());
    }

    public List<EndpointListener> getListeners() {
        return this.listeners;
    }

    public void removeEndpoint(Endpoint endpoint) {
        this.map.remove((Object)endpoint.getURI());
        for (EndpointListener listener : this.listeners) {
            listener.endpointRemoved(endpoint);
        }
        logger.info("EndpointRegistry: Remove endpoint - " + endpoint);
    }

    public void removeEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.remove(endpointReference);
        logger.info("EndpointRegistry: Remove endpoint reference - " + endpointReference);
    }

    public void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
    }

    public void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        this.map.put((Object)endpoint.getURI(), (Object)endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEndpoint, endpoint);
        }
    }

    public static void main(String[] args) throws Exception {
        GroupChannel channel = new GroupChannel();
        McastService mcastService = (McastService)channel.getMembershipService();
        mcastService.setPort(50000);
        mcastService.setAddress(MULTICAST_ADDRESS);
        InetAddress localhost = InetAddress.getLocalHost();
        mcastService.setBind("192.168.1.100");
        channel.start(15);
        ReplicatedMap map = new ReplicatedMap(null, (Channel)channel, 50L, "01", null);
        map.put((Object)UUID.randomUUID().toString(), (Object)localhost.getHostAddress());
        int i = 0;
        while (i < 5) {
            Thread.sleep(2000L);
            System.out.println(localhost + ": " + map.keySet());
            ++i;
        }
        for (Object e : map.entrySetFull()) {
            Map.Entry en = (Map.Entry)e;
            AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)en.getValue();
            System.out.println(entry);
        }
        map.breakdown();
        channel.stop(15);
    }
}

