/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapStore
extends ConcurrentHashMap<Object, Object> {
    private static final long serialVersionUID = -2127235547082144368L;
    private List<MapListener> listeners = new CopyOnWriteArrayList<MapListener>();

    protected MapStore(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public Object put(Object key, Object value) {
        Object old = super.put(key, value);
        if (old != null) {
            for (MapListener listener : this.listeners) {
                listener.entryUpdated(key, old, value);
            }
        } else {
            for (MapListener listener : this.listeners) {
                listener.entryAdded(key, value);
            }
        }
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = super.remove(key);
        if (old != null) {
            for (MapListener listener : this.listeners) {
                listener.entryRemoved(key, old);
            }
        }
        return old;
    }

    public void addListener(MapListener listener) {
        this.listeners.add(listener);
    }

    public List<MapListener> getListeners() {
        return this.listeners;
    }

    public boolean removeListener(MapListener listener) {
        return this.listeners.remove(listener);
    }

    public static interface MapListener {
        public void entryAdded(Object var1, Object var2);

        public void entryUpdated(Object var1, Object var2, Object var3);

        public void entryRemoved(Object var1, Object var2);
    }
}

