/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.endpoint.tribes.AbstractReplicatedMap;
import org.apache.tuscany.sca.endpoint.tribes.DisableMcastInterceptor;
import org.apache.tuscany.sca.endpoint.tribes.MapStore;
import org.apache.tuscany.sca.endpoint.tribes.ReplicatedMap;
import org.apache.tuscany.sca.runtime.BaseEndpointRegistry;
import org.apache.tuscany.sca.runtime.DomainRegistryURI;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedEndpointRegistry
extends BaseEndpointRegistry
implements EndpointRegistry,
LifeCycleListener,
MapStore.MapListener {
    private static final Logger logger = Logger.getLogger(ReplicatedEndpointRegistry.class.getName());
    private static final String MULTICAST_ADDRESS = "228.0.0.100";
    private static final int MULTICAST_PORT = 50000;
    private static final int FIND_REPEAT_COUNT = 10;
    private int port = 50000;
    private String address = "228.0.0.100";
    private String bind = null;
    private int timeout = 50;
    private String receiverAddress;
    private int receiverPort = 4000;
    private int receiverAutoBind = 100;
    private List<URI> staticRoutes;
    private ReplicatedMap map;
    private String id;
    private boolean noMultiCast;

    private static final GroupChannel createChannel(String address, int port, String bindAddress) {
        GroupChannel channel = new GroupChannel();
        McastService mcastService = (McastService)channel.getMembershipService();
        mcastService.setPort(port);
        mcastService.setAddress(address);
        if (bindAddress != null) {
            mcastService.setBind(bindAddress);
        } else {
            mcastService.setBind(ReplicatedEndpointRegistry.getBindAddress());
        }
        return channel;
    }

    public ReplicatedEndpointRegistry(ExtensionPointRegistry registry, Map<String, String> attributes, String domainRegistryURI, String domainURI) {
        super(registry, attributes, domainRegistryURI, domainURI);
        this.getParameters(attributes, domainRegistryURI);
    }

    private Map<String, String> getParameters(Map<String, String> attributes, String domainRegistryURI) {
        String[] params;
        URI uri;
        HashMap<String, String> map = new HashMap<String, String>();
        if (attributes != null) {
            map.putAll(attributes);
        }
        if ((uri = URI.create(domainRegistryURI)).getHost() != null) {
            map.put("address", uri.getHost());
        }
        if (uri.getPort() != -1) {
            map.put("port", String.valueOf(uri.getPort()));
        }
        if (domainRegistryURI.startsWith("tuscany")) {
            this.setTuscanyConfig(map, domainRegistryURI);
            this.setConfig(map);
            return map;
        }
        int index = domainRegistryURI.indexOf(63);
        if (index == -1) {
            this.setConfig(map);
            return map;
        }
        String query = domainRegistryURI.substring(index + 1);
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        for (String param : params = query.split("&")) {
            index = param.indexOf(61);
            if (index == -1) continue;
            map.put(param.substring(0, index), param.substring(index + 1));
        }
        this.setConfig(map);
        return map;
    }

    private void setTuscanyConfig(Map<String, String> map, String domainRegistryURI) {
        DomainRegistryURI tuscanyURI = new DomainRegistryURI(domainRegistryURI);
        map.put("address", tuscanyURI.getMulticastAddress());
        map.put("port", Integer.toString(tuscanyURI.getMulticastPort()));
        map.put("bind", tuscanyURI.getBindAddress());
        map.put("receiverPort", Integer.toString(tuscanyURI.getListenPort()));
        if (tuscanyURI.isMulticastDisabled()) {
            map.put("nomcast", "true");
        }
        if (tuscanyURI.getRemotes().size() > 0) {
            String routes = "";
            for (int i = 0; i < tuscanyURI.getRemotes().size(); ++i) {
                routes = routes + (String)tuscanyURI.getRemotes().get(i);
                if (i >= tuscanyURI.getRemotes().size()) continue;
                routes = routes + ",";
            }
            map.put("routes", routes);
        }
    }

    private void setConfig(Map<String, String> attributes) {
        String recvAutoBind;
        String mcast;
        String routesStr;
        String address;
        String portStr = attributes.get("port");
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
            if (this.port == -1) {
                this.port = 50000;
            }
        }
        if ((address = attributes.get("address")) == null) {
            address = MULTICAST_ADDRESS;
        }
        this.bind = attributes.get("bind");
        String timeoutStr = attributes.get("timeout");
        if (timeoutStr != null) {
            this.timeout = Integer.parseInt(timeoutStr);
        }
        if ((routesStr = attributes.get("routes")) != null) {
            StringTokenizer st = new StringTokenizer(routesStr);
            this.staticRoutes = new ArrayList<URI>();
            while (st.hasMoreElements()) {
                this.staticRoutes.add(URI.create("tcp://" + st.nextToken()));
            }
        }
        if ((mcast = attributes.get("nomcast")) != null) {
            this.noMultiCast = Boolean.valueOf(mcast);
        }
        this.receiverAddress = attributes.get("receiverAddress");
        String recvPort = attributes.get("receiverPort");
        if (recvPort != null) {
            this.receiverPort = Integer.parseInt(recvPort);
        }
        if ((recvAutoBind = attributes.get("receiverAutoBind")) != null) {
            this.receiverAutoBind = Integer.parseInt(recvAutoBind);
        }
    }

    public void start() {
        ChannelReceiver receiver;
        if (this.map != null) {
            throw new IllegalStateException("The registry has already been started");
        }
        GroupChannel channel = ReplicatedEndpointRegistry.createChannel(this.address, this.port, this.bind);
        this.map = new ReplicatedMap(null, (Channel)channel, this.timeout, this.domainURI, new ClassLoader[]{ReplicatedEndpointRegistry.class.getClassLoader()});
        this.map.addListener(this);
        if (this.noMultiCast) {
            this.map.getChannel().addInterceptor((ChannelInterceptor)new DisableMcastInterceptor());
        }
        if ((receiver = channel.getChannelReceiver()) instanceof ReceiverBase) {
            if (this.receiverAddress != null) {
                ((ReceiverBase)receiver).setAddress(this.receiverAddress);
            }
            ((ReceiverBase)receiver).setPort(this.receiverPort);
            ((ReceiverBase)receiver).setAutoBind(this.receiverAutoBind);
        }
        if (this.staticRoutes != null) {
            StaticMembershipInterceptor smi = new StaticMembershipInterceptor();
            for (URI staticRoute : this.staticRoutes) {
                StaticMember member;
                try {
                    member = new StaticMember(staticRoute.getHost(), staticRoute.getPort(), 5000L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                smi.addStaticMember((Member)member);
                logger.info("Added static route: " + staticRoute.getHost() + ":" + staticRoute.getPort());
            }
            smi.setLocalMember(this.map.getChannel().getLocalMember(false));
            this.map.getChannel().addInterceptor((ChannelInterceptor)smi);
        }
        try {
            this.map.getChannel().start(15);
        }
        catch (ChannelException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() {
        if (this.map != null) {
            this.map.removeListener(this);
            Channel channel = this.map.getChannel();
            this.map.breakdown();
            try {
                channel.stop(15);
            }
            catch (ChannelException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.map = null;
        }
    }

    public void addEndpoint(Endpoint endpoint) {
        this.map.put(endpoint.getURI(), endpoint);
        logger.info("Add endpoint - " + endpoint);
    }

    public List<Endpoint> findEndpoint(String uri) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        int repeat = 10;
        while (repeat > 0) {
            for (Object v : this.map.values()) {
                Endpoint endpoint = (Endpoint)v;
                logger.fine("Matching against - " + endpoint);
                if (!endpoint.matches(uri)) continue;
                AbstractReplicatedMap.MapEntry entry = this.map.getInternal(endpoint.getURI());
                ((RuntimeEndpoint)endpoint).bind(this.registry, (EndpointRegistry)this);
                foundEndpoints.add(endpoint);
                logger.fine("Found endpoint with matching service  - " + endpoint);
                repeat = 0;
            }
            if (foundEndpoints.size() != 0) continue;
            logger.info("Repeating endpoint reference match - " + uri);
            --repeat;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                repeat = 0;
            }
        }
        return foundEndpoints;
    }

    private boolean isLocal(AbstractReplicatedMap.MapEntry entry) {
        return entry.getPrimary().equals(this.map.getChannel().getLocalMember(false));
    }

    public Endpoint getEndpoint(String uri) {
        return (Endpoint)this.map.get(uri);
    }

    public List<Endpoint> getEndpoints() {
        return new ArrayList<Object>(this.map.values());
    }

    public void removeEndpoint(Endpoint endpoint) {
        this.map.remove(endpoint.getURI());
        logger.info("Remove endpoint - " + endpoint);
    }

    public void replicate(boolean complete) {
        this.map.replicate(complete);
    }

    public void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        this.map.put(endpoint.getURI(), endpoint);
    }

    @Override
    public void entryAdded(Object key, Object value) {
        AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)value;
        Endpoint newEp = (Endpoint)entry.getValue();
        if (!this.isLocal(entry)) {
            logger.info(this.id + " Remote endpoint added: " + entry.getValue());
        }
        this.endpointAdded(newEp);
    }

    @Override
    public void entryRemoved(Object key, Object value) {
        AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)value;
        if (!this.isLocal(entry)) {
            logger.info(this.id + " Remote endpoint removed: " + entry.getValue());
        }
        this.endpointRemoved((Endpoint)entry.getValue());
    }

    @Override
    public void entryUpdated(Object key, Object oldValue, Object newValue) {
        AbstractReplicatedMap.MapEntry oldEntry = (AbstractReplicatedMap.MapEntry)oldValue;
        AbstractReplicatedMap.MapEntry newEntry = (AbstractReplicatedMap.MapEntry)newValue;
        if (!this.isLocal(newEntry)) {
            logger.info(this.id + " Remote endpoint updated: " + newEntry.getValue());
        }
        Endpoint oldEp = (Endpoint)oldEntry.getValue();
        Endpoint newEp = (Endpoint)newEntry.getValue();
        this.endpointUpdated(oldEp, newEp);
    }

    private static String getBindAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                if (!ips.hasMoreElements()) continue;
                while (ips.hasMoreElements()) {
                    InetAddress addr = ips.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    return addr.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

