/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.endpointresolver.EndpointResolver;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactory;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactoryExtensionPoint;

public class EndpointResolverImpl
implements EndpointResolver {
    private static final Logger logger = Logger.getLogger(EndpointResolverImpl.class.getName());
    private Endpoint endpoint;
    private List<EndpointResolver> endpointResolvers = new ArrayList<EndpointResolver>();

    public EndpointResolverImpl(ExtensionPointRegistry extensionPoints, Endpoint endpoint) {
        this.endpoint = endpoint;
        EndpointResolverFactoryExtensionPoint resolverFactories = (EndpointResolverFactoryExtensionPoint)extensionPoints.getExtensionPoint(EndpointResolverFactoryExtensionPoint.class);
        for (Binding binding : endpoint.getCandidateBindings()) {
            EndpointResolver resolver;
            EndpointResolverFactory resolverFactory = resolverFactories.getEndpointResolverFactory(binding.getClass());
            if (resolverFactory == null || (resolver = resolverFactory.createEndpointResolver(endpoint, binding)) == null) continue;
            this.endpointResolvers.add(resolver);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void resolve() {
        if (this.endpoint.isUnresolved()) {
            for (EndpointResolver resolver : this.endpointResolvers) {
                resolver.resolve();
                if (!this.endpoint.isUnresolved()) break;
            }
            if (this.endpoint.isUnresolved()) {
                this.endpoint.setSourceBinding((Binding)this.endpoint.getCandidateBindings().get(0));
                this.endpoint.getSourceBinding().setURI(this.endpoint.getTargetName());
            }
            this.endpoint.isUnresolved();
        }
    }
}

