/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint2;
import org.apache.tuscany.sca.assembly.EndpointReference2;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.EndpointReferenceBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceBuilderImpl
implements CompositeBuilder,
EndpointReferenceBuilder {
    protected ExtensionPointRegistry extensionPoints;
    protected AssemblyFactory assemblyFactory;
    protected InterfaceContractMapper interfaceContractMapper;

    public EndpointReferenceBuilderImpl(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
    }

    public EndpointReferenceBuilderImpl(FactoryExtensionPoint factories, InterfaceContractMapper mapper) {
        this.assemblyFactory = (AssemblyFactory)factories.getFactory(AssemblyFactory.class);
        this.interfaceContractMapper = mapper;
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.EndpointReferenceBuilder";
    }

    protected void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = null;
            problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    protected void indexComponents(Composite composite, Map<String, Component> components) {
        for (Component component : composite.getComponents()) {
            components.put(component.getName(), component);
        }
    }

    protected void indexServices(Composite composite, Map<String, ComponentService> componentServices) {
        for (Component component : composite.getComponents()) {
            ComponentService nonCallbackService = null;
            int nonCallbackServiceCount = 0;
            for (ComponentService componentService : component.getServices()) {
                String uri = String.valueOf(component.getName()) + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                if (componentService.isCallback()) continue;
                if (nonCallbackServiceCount == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServiceCount;
            }
            if (nonCallbackServiceCount != true) continue;
            componentServices.put(component.getName(), nonCallbackService);
        }
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.processComponentReferences(composite, monitor);
    }

    private void processCompositeReferences(Composite composite) {
    }

    private void processComponentReferences(Composite composite, Monitor monitor) {
        HashMap<String, Component> components = new HashMap<String, Component>();
        this.indexComponents(composite, components);
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        this.indexServices(composite, componentServices);
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.processComponentReferences((Composite)implementation, monitor);
            }
            for (ComponentReference reference : component.getReferences()) {
                for (EndpointReference2 endpointReference : reference.getEndpointReferences()) {
                    this.build(endpointReference, monitor);
                }
            }
        }
    }

    public void build(EndpointReference2 endpointReference, Monitor monitor) {
        Endpoint2 endpoint = endpointReference.getTargetEndpoint();
        if (endpoint != null) {
            if (!endpoint.isUnresolved()) {
                return;
            }
            if (!endpointReference.isUnresolved()) {
                this.matchForwardBinding(endpointReference, monitor);
                this.matchCallbackBinding(endpointReference, monitor);
            }
        }
    }

    private void matchForwardBinding(EndpointReference2 endpointReference, Monitor monitor) {
        Endpoint2 serviceEndpoint2;
        Endpoint2 endpoint = endpointReference.getTargetEndpoint();
        ArrayList<Binding> matchedReferenceBinding = new ArrayList<Binding>();
        ArrayList<Endpoint2> matchedServiceEndpoint = new ArrayList<Endpoint2>();
        for (Binding referenceBinding : endpointReference.getReference().getBindings()) {
            for (Endpoint2 serviceEndpoint2 : endpoint.getService().getEndpoints()) {
                if (referenceBinding.getClass() != serviceEndpoint2.getBinding().getClass() || !this.hasCompatiblePolicySets(referenceBinding, serviceEndpoint2.getBinding())) continue;
                matchedReferenceBinding.add(referenceBinding);
                matchedServiceEndpoint.add(serviceEndpoint2);
            }
        }
        if (matchedReferenceBinding.isEmpty()) {
            endpointReference.setBinding(null);
            endpointReference.setTargetEndpoint(null);
            this.warning(monitor, "NoMatchingBinding", endpointReference.getReference(), endpointReference.getReference().getName(), endpoint.getService().getName());
            return;
        }
        int selectedBinding = 0;
        int i = 0;
        while (i < matchedReferenceBinding.size()) {
            if (SCABinding.class.isInstance(matchedReferenceBinding.get(i))) {
                selectedBinding = i;
            }
            ++i;
        }
        Binding referenceBinding = (Binding)matchedReferenceBinding.get(selectedBinding);
        serviceEndpoint2 = (Endpoint2)matchedServiceEndpoint.get(selectedBinding);
        try {
            Binding cloned = (Binding)referenceBinding.clone();
            if (referenceBinding.getURI() == null) {
                cloned.setURI(serviceEndpoint2.getBinding().getURI());
            }
            if (cloned instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)cloned;
                optimizableBinding.setTargetComponent(serviceEndpoint2.getComponent());
                optimizableBinding.setTargetComponentService(serviceEndpoint2.getService());
                optimizableBinding.setTargetBinding(serviceEndpoint2.getBinding());
            }
            endpointReference.setBinding(cloned);
            endpointReference.setTargetEndpoint(serviceEndpoint2);
        }
        catch (Exception exception) {}
    }

    private void matchCallbackBinding(EndpointReference2 endpointReference, Monitor monitor) {
        if (endpointReference.getReference().getInterfaceContract() == null || endpointReference.getReference().getInterfaceContract().getCallbackInterface() == null || endpointReference.getReference().getName().startsWith("$self$.")) {
            return;
        }
        Endpoint2 endpoint = endpointReference.getTargetEndpoint();
        List callbackEndpoints = endpointReference.getReference().getCallbackService().getEndpoints();
        List callbackEndpointReferences = endpoint.getCallbackEndpointReferences();
        ArrayList<Endpoint2> matchedEndpoint = new ArrayList<Endpoint2>();
        if (callbackEndpoints != null && callbackEndpointReferences != null) {
            for (EndpointReference2 epr : callbackEndpointReferences) {
                for (Endpoint2 ep : callbackEndpoints) {
                    if (epr.getBinding().getClass() != ep.getBinding().getClass() || !this.hasCompatiblePolicySets(epr.getBinding(), ep.getBinding())) continue;
                    matchedEndpoint.add(ep);
                }
            }
        }
        if (matchedEndpoint.isEmpty()) {
            endpointReference.setCallbackEndpoint(null);
            this.warning(monitor, "NoMatchingCallbackBinding", endpointReference.getReference(), endpointReference.getReference().getName(), endpoint.getService().getName());
            return;
        }
        int selectedEndpoint = 0;
        int i = 0;
        while (i < matchedEndpoint.size()) {
            if (SCABinding.class.isInstance(((Endpoint2)matchedEndpoint.get(i)).getBinding())) {
                selectedEndpoint = i;
            }
            ++i;
        }
        endpointReference.setCallbackEndpoint((Endpoint2)matchedEndpoint.get(selectedEndpoint));
    }

    private boolean hasCompatiblePolicySets(Binding refBinding, Binding svcBinding) {
        boolean isCompatible = true;
        if (refBinding instanceof PolicySubject && svcBinding instanceof PolicySubject) {
            for (PolicySet svcPolicySet : ((PolicySubject)svcBinding).getPolicySets()) {
                isCompatible = false;
                for (PolicySet refPolicySet : ((PolicySubject)refBinding).getPolicySets()) {
                    if (!svcPolicySet.equals(refPolicySet)) continue;
                    isCompatible = true;
                    break;
                }
                if (isCompatible) continue;
                return isCompatible;
            }
        }
        return isCompatible;
    }
}

