/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.EndpointReferenceBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.oasisopen.sca.SCARuntimeException;

public class EndpointReferenceBuilderImpl
implements CompositeBuilder,
EndpointReferenceBuilder {
    protected ExtensionPointRegistry extensionPoints;
    protected AssemblyFactory assemblyFactory;
    protected InterfaceContractMapper interfaceContractMapper;
    protected EndpointRegistry endpointRegistry;

    public EndpointReferenceBuilderImpl(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        FactoryExtensionPoint factories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)factories.getFactory(AssemblyFactory.class);
        UtilityExtensionPoint utils = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utils.getUtility(InterfaceContractMapper.class);
        this.endpointRegistry = (EndpointRegistry)utils.getUtility(EndpointRegistry.class);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.EndpointReferenceBuilder";
    }

    protected void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = null;
            problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
    }

    public void build(EndpointReference endpointReference, Monitor monitor) {
        Endpoint endpoint = endpointReference.getTargetEndpoint();
        if (endpoint != null) {
            if (!endpoint.isUnresolved()) {
                return;
            }
            if (!endpointReference.isUnresolved()) {
                this.matchForwardBinding(endpointReference, true, monitor);
                this.matchCallbackBinding(endpointReference, monitor);
            } else {
                List endpoints = this.endpointRegistry.findEndpoint(endpointReference);
                if (endpoints.size() == 0) {
                    throw new SCARuntimeException("No endpoints found for EndpointReference " + endpointReference.toString());
                }
                if (endpoints.size() > 1) {
                    throw new SCARuntimeException("More than one endpoint found for EndpointReference" + endpointReference.toString());
                }
                endpointReference.setTargetEndpoint((Endpoint)endpoints.get(0));
                this.matchForwardBinding(endpointReference, false, monitor);
                this.matchCallbackBinding(endpointReference, monitor);
            }
        }
        if (endpointReference.isUnresolved()) {
            throw new SCARuntimeException("Can't resolve " + endpointReference.toString());
        }
    }

    private void matchForwardBinding(EndpointReference endpointReference, boolean local, Monitor monitor) {
        Endpoint serviceEndpoint2;
        Endpoint endpoint = endpointReference.getTargetEndpoint();
        ArrayList<Binding> matchedReferenceBinding = new ArrayList<Binding>();
        ArrayList<Endpoint> matchedServiceEndpoint = new ArrayList<Endpoint>();
        if (endpointReference.getReference().getBindings().size() == 0 || endpointReference.getReference().getBindings().size() == 1 && endpointReference.getReference().getBindings().get(0) instanceof SCABinding) {
            endpointReference.setTargetEndpoint((Endpoint)endpoint.getService().getEndpoints().get(0));
            endpointReference.setBinding(endpointReference.getTargetEndpoint().getBinding());
            endpointReference.setUnresolved(false);
            return;
        }
        for (Binding referenceBinding : endpointReference.getReference().getBindings()) {
            if (local) {
                for (Endpoint serviceEndpoint2 : endpoint.getService().getEndpoints()) {
                    if (referenceBinding.getClass() != serviceEndpoint2.getBinding().getClass() || !this.hasCompatiblePolicySets(referenceBinding, serviceEndpoint2.getBinding())) continue;
                    matchedReferenceBinding.add(referenceBinding);
                    matchedServiceEndpoint.add(serviceEndpoint2);
                }
                continue;
            }
            serviceEndpoint2 = endpoint;
            if (referenceBinding.getClass() != serviceEndpoint2.getBinding().getClass() || !this.hasCompatiblePolicySets(referenceBinding, serviceEndpoint2.getBinding())) continue;
            matchedReferenceBinding.add(referenceBinding);
            matchedServiceEndpoint.add(serviceEndpoint2);
        }
        if (matchedReferenceBinding.isEmpty()) {
            endpointReference.setBinding(null);
            endpointReference.setUnresolved(true);
            this.warning(monitor, "NoMatchingBinding", endpointReference.getReference(), endpointReference.getReference().getName(), endpoint.getService().getName());
            return;
        }
        int selectedBinding = 0;
        int i = 0;
        while (i < matchedReferenceBinding.size()) {
            if (SCABinding.class.isInstance(matchedReferenceBinding.get(i))) {
                selectedBinding = i;
            }
            ++i;
        }
        Binding referenceBinding = (Binding)matchedReferenceBinding.get(selectedBinding);
        serviceEndpoint2 = (Endpoint)matchedServiceEndpoint.get(selectedBinding);
        try {
            Binding clonedBinding = (Binding)referenceBinding.clone();
            if (referenceBinding.getURI() == null) {
                clonedBinding.setURI(serviceEndpoint2.getBinding().getURI());
            }
            if (clonedBinding instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)clonedBinding;
                optimizableBinding.setTargetComponent(serviceEndpoint2.getComponent());
                optimizableBinding.setTargetComponentService(serviceEndpoint2.getService());
                optimizableBinding.setTargetBinding(serviceEndpoint2.getBinding());
            }
            endpointReference.setBinding(clonedBinding);
            Endpoint clonedEndpoint = (Endpoint)serviceEndpoint2.clone();
            endpointReference.setTargetEndpoint(clonedEndpoint);
            endpointReference.setUnresolved(false);
        }
        catch (Exception exception) {}
    }

    private void matchCallbackBinding(EndpointReference endpointReference, Monitor monitor) {
        if (endpointReference.getReference().getInterfaceContract() == null || endpointReference.getReference().getInterfaceContract().getCallbackInterface() == null || endpointReference.getReference().getName().startsWith("$self$.")) {
            return;
        }
        Endpoint endpoint = endpointReference.getTargetEndpoint();
        List callbackEndpoints = endpointReference.getReference().getCallbackService().getEndpoints();
        List callbackEndpointReferences = endpoint.getCallbackEndpointReferences();
        ArrayList<Endpoint> matchedEndpoint = new ArrayList<Endpoint>();
        if (((EndpointReference)callbackEndpointReferences.get(0)).getReference().getBindings().size() == 0 || ((EndpointReference)callbackEndpointReferences.get(0)).getReference().getBindings().size() == 1 && ((EndpointReference)callbackEndpointReferences.get(0)).getReference().getBindings().get(0) instanceof SCABinding) {
            endpointReference.setCallbackEndpoint((Endpoint)callbackEndpoints.get(0));
            endpointReference.setUnresolved(false);
            return;
        }
        if (callbackEndpoints != null && callbackEndpointReferences != null) {
            for (EndpointReference epr : callbackEndpointReferences) {
                for (Endpoint ep : callbackEndpoints) {
                    if (epr.getBinding().getClass() != ep.getBinding().getClass() || !this.hasCompatiblePolicySets(epr.getBinding(), ep.getBinding())) continue;
                    matchedEndpoint.add(ep);
                }
            }
        }
        if (matchedEndpoint.isEmpty()) {
            endpointReference.setCallbackEndpoint(null);
            endpointReference.setUnresolved(true);
            this.warning(monitor, "NoMatchingCallbackBinding", endpointReference.getReference(), endpointReference.getReference().getName(), endpoint.getService().getName());
            return;
        }
        int selectedEndpoint = 0;
        int i = 0;
        while (i < matchedEndpoint.size()) {
            if (SCABinding.class.isInstance(((Endpoint)matchedEndpoint.get(i)).getBinding())) {
                selectedEndpoint = i;
            }
            ++i;
        }
        endpointReference.setCallbackEndpoint((Endpoint)matchedEndpoint.get(selectedEndpoint));
        endpointReference.setUnresolved(false);
    }

    private boolean hasCompatiblePolicySets(Binding refBinding, Binding svcBinding) {
        boolean isCompatible = true;
        if (refBinding instanceof PolicySubject && svcBinding instanceof PolicySubject) {
            for (PolicySet svcPolicySet : ((PolicySubject)svcBinding).getPolicySets()) {
                isCompatible = false;
                for (PolicySet refPolicySet : ((PolicySubject)refBinding).getPolicySets()) {
                    if (!svcPolicySet.equals(refPolicySet)) continue;
                    isCompatible = true;
                    break;
                }
                if (isCompatible) continue;
                return isCompatible;
            }
        }
        return isCompatible;
    }
}

