/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistryImpl
implements EndpointRegistry {
    private final Logger logger = Logger.getLogger(EndpointRegistryImpl.class.getName());
    static List<Endpoint> endpoints = new ArrayList<Endpoint>();
    static List<EndpointReference> endpointreferences = new ArrayList<EndpointReference>();
    private List<EndpointListener> listeners = new CopyOnWriteArrayList<EndpointListener>();

    public EndpointRegistryImpl(ExtensionPointRegistry extensionPoints) {
    }

    public void addEndpoint(Endpoint endpoint) {
        endpoints.add(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(endpoint);
        }
        this.logger.info("EndpointRegistry: Add endpoint - " + endpoint.toString());
    }

    public void addEndpointReference(EndpointReference endpointReference) {
        endpointreferences.add(endpointReference);
        this.logger.info("EndpointRegistry: Add endpoint reference - " + endpointReference.toString());
    }

    private String[] parse(String uri) {
        String[] names = new String[3];
        int index = uri.lastIndexOf(35);
        if (index == -1) {
            names[0] = uri;
        } else {
            names[0] = uri.substring(0, index);
            String str = uri.substring(index + 1);
            if (str.startsWith("service-binding(") && str.endsWith(")")) {
                String[] parts = (str = str.substring("service-binding(".length(), str.length() - 1)).split("/");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid service-binding URI: " + uri);
                }
                names[1] = parts[0];
                names[2] = parts[1];
            } else if (str.startsWith("service(") && str.endsWith(")")) {
                names[1] = str = str.substring("service(".length(), str.length() - 1);
            } else {
                throw new IllegalArgumentException("Invalid component/service/binding URI: " + uri);
            }
        }
        return names;
    }

    private boolean matches(String target, String uri) {
        String[] parts1 = this.parse(target);
        String[] parts2 = this.parse(uri);
        int i = 0;
        while (i < parts1.length) {
            if (parts1[i] != null && !parts1[i].equals(parts2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<Endpoint> findEndpoint(EndpointReference endpointReference) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        this.logger.info("EndpointRegistry: Find endpoint for reference - " + endpointReference.toString());
        if (endpointReference.getReference() != null) {
            Endpoint targetEndpoint = endpointReference.getTargetEndpoint();
            for (Endpoint endpoint : endpoints) {
                if (!this.matches(targetEndpoint.getURI(), endpoint.getURI())) continue;
                foundEndpoints.add(endpoint);
                this.logger.info("EndpointRegistry: Found endpoint with matching service  - " + endpoint);
            }
        }
        return foundEndpoints;
    }

    public List<EndpointReference> findEndpointReference(Endpoint endpoint) {
        return null;
    }

    public void removeEndpoint(Endpoint endpoint) {
        endpoints.remove(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointRemoved(endpoint);
        }
        this.logger.info("EndpointRegistry: Remove endpoint - " + endpoint.toString());
    }

    public void removeEndpointReference(EndpointReference endpointReference) {
        endpointreferences.remove(endpointReference);
        this.logger.info("EndpointRegistry: Remove endpoint reference - " + endpointReference.toString());
    }

    public List<EndpointReference> getEndpointRefereneces() {
        return endpointreferences;
    }

    public List<Endpoint> getEndpoints() {
        return endpoints;
    }

    public void addListener(EndpointListener listener) {
        this.listeners.add(listener);
    }

    public List<EndpointListener> getListeners() {
        return this.listeners;
    }

    public void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
    }

    public Endpoint getEndpoint(String uri) {
        for (Endpoint ep : endpoints) {
            String epURI = String.valueOf(ep.getComponent().getURI()) + "#" + ep.getService().getName() + "/" + ep.getBinding().getName();
            if (epURI.equals(uri)) {
                return ep;
            }
            if (ep.getBinding().getName() != null && !ep.getBinding().getName().equals(ep.getService().getName()) || !(epURI = String.valueOf(ep.getComponent().getURI()) + "#" + ep.getService().getName()).equals(uri)) continue;
            return ep;
        }
        return null;
    }

    public void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        endpoints.remove(oldEndpoint);
        this.addEndpoint(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEndpoint, endpoint);
        }
    }
}

