/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.provider;

import java.io.File;
import java.net.URL;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;
import org.apache.tuscany.sca.implementation.bpel.ode.EmbeddedODEServer;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEDeployment;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEInitializationException;
import org.apache.tuscany.sca.implementation.bpel.provider.BPELInvoker;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class BPELImplementationProvider
implements ImplementationProvider {
    private final Log __log = LogFactory.getLog(this.getClass());
    private RuntimeComponent component;
    private BPELImplementation implementation;
    private EmbeddedODEServer odeServer;
    private TransactionManager txMgr;

    public BPELImplementationProvider(RuntimeComponent component, BPELImplementation implementation, EmbeddedODEServer odeServer, TransactionManager txMgr) {
        this.component = component;
        this.implementation = implementation;
        this.odeServer = odeServer;
        this.txMgr = txMgr;
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        BPELInvoker invoker = new BPELInvoker(this.component, service, operation, this.odeServer, this.txMgr);
        return invoker;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        if (this.__log.isInfoEnabled()) {
            this.__log.info((Object)("Starting " + this.component.getName()));
        }
        try {
            if (!this.odeServer.isInitialized()) {
                this.odeServer.init();
            }
            URL deployURL = this.implementation.getProcessDefinition().getLocation();
            File deploymentDir = new File(deployURL.toURI().getPath()).getParentFile();
            if (this.__log.isInfoEnabled()) {
                this.__log.info((Object)(">>> Deploying : " + deploymentDir.toString()));
            }
            if (this.odeServer.isInitialized()) {
                try {
                    this.odeServer.registerTuscanyRuntimeComponent(this.implementation.getProcess(), this.component);
                    this.odeServer.deploy(new ODEDeployment(deploymentDir), this.implementation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ODEInitializationException inite) {
            throw new RuntimeException("BPEL Component Type Implementation : Error initializing embedded ODE server " + inite.getMessage(), inite);
        }
        catch (Exception e) {
            throw new RuntimeException("BPEl Component Type Implementation initialization failure : " + e.getMessage(), e);
        }
    }

    public void stop() {
        if (this.__log.isInfoEnabled()) {
            this.__log.info((Object)("Stopping " + this.component.getName()));
        }
        if (this.odeServer.isInitialized()) {
            this.odeServer.stop();
        }
        this.txMgr = null;
        if (this.__log.isInfoEnabled()) {
            this.__log.info((Object)"Stopped !!!");
        }
    }
}

