/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.tuscany.sca.implementation.bpel.ode.TuscanyEPR;
import org.apache.tuscany.sca.implementation.bpel.ode.TuscanyPRC;

public class ODEBindingContext
implements BindingContext {
    protected final Log __log = LogFactory.getLog(this.getClass());

    public EndpointReference activateMyRoleEndpoint(QName pid, Endpoint endpoint) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("Activating MyRole Endpoint : " + pid + " - " + endpoint.serviceName));
        }
        QName processName = ODEBindingContext.getProcessName(pid);
        return new TuscanyEPR(processName, endpoint);
    }

    public void deactivateMyRoleEndpoint(Endpoint endpoint) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("Deactivate MyRole Endpoint : " + endpoint.serviceName));
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName pid, PortType portType, Endpoint endpoint) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("Create PartnerRole channel : " + pid + " - " + portType.getQName() + " - " + endpoint.serviceName));
        }
        QName processName = ODEBindingContext.getProcessName(pid);
        return new TuscanyPRC(processName, pid, portType, endpoint);
    }

    private static QName getProcessName(QName pid) {
        String processName = pid.getLocalPart().substring(0, pid.getLocalPart().lastIndexOf("-"));
        return new QName(pid.getNamespaceURI(), processName);
    }
}

