/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import java.util.concurrent.Callable;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.implementation.bpel.ode.EmbeddedODEServer;
import org.apache.tuscany.sca.implementation.bpel.ode.TuscanyPRC;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEExternalService {
    protected final Log __log = LogFactory.getLog(this.getClass());
    private EmbeddedODEServer _server;
    private Scheduler _sched;

    public ODEExternalService(EmbeddedODEServer server) {
        this._server = server;
        this._sched = this._server.getScheduler();
    }

    public void invoke(final PartnerRoleMessageExchange partnerRoleMessageExchange) {
        boolean isTwoWay;
        boolean bl = isTwoWay = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (isTwoWay) {
            this._sched.registerSynchronizer(new Scheduler.Synchronizer(){

                public void beforeCompletion() {
                }

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    ODEExternalService.this._server.getExecutor().submit(new Callable<Object>(this, partnerRoleMessageExchange){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ PartnerRoleMessageExchange val$partnerRoleMessageExchange;
                        {
                            this.this$1 = var1_1;
                            this.val$partnerRoleMessageExchange = partnerRoleMessageExchange;
                        }

                        public Object call() throws Exception {
                            block8: {
                                Object result;
                                Operation operation;
                                block9: {
                                    if (!(this.val$partnerRoleMessageExchange.getChannel() instanceof TuscanyPRC)) {
                                        throw new IllegalArgumentException("Channel should be an instance of TuscanyPRC");
                                    }
                                    TuscanyPRC channel = (TuscanyPRC)this.val$partnerRoleMessageExchange.getChannel();
                                    RuntimeComponent tuscanyRuntimeComponent = ODEExternalService.access$0(1.access$0(this.this$1)).getTuscanyRuntimeComponent(channel.getProcessName());
                                    RuntimeComponentReference runtimeComponentReference = (RuntimeComponentReference)tuscanyRuntimeComponent.getReferences().get(0);
                                    RuntimeWire runtimeWire = runtimeComponentReference.getRuntimeWire((Binding)runtimeComponentReference.getBindings().get(0));
                                    operation = ODEExternalService.access$1(1.access$0(this.this$1), this.val$partnerRoleMessageExchange.getOperation().getName(), runtimeComponentReference);
                                    Element msg = this.val$partnerRoleMessageExchange.getRequest().getMessage();
                                    if (msg == null) break block8;
                                    String xml = DOMUtils.domToString((Node)msg);
                                    String payload = DOMUtils.domToString((Node)ODEExternalService.access$2(1.access$0(this.this$1), this.val$partnerRoleMessageExchange.getRequest()));
                                    if (1.access$0(this.this$1).__log.isDebugEnabled()) {
                                        1.access$0(this.this$1).__log.debug((Object)"Starting invocation of SCA Reference");
                                        1.access$0(this.this$1).__log.debug((Object)(">>> Original message: " + xml));
                                        1.access$0(this.this$1).__log.debug((Object)(">>> Payload: " + payload));
                                    }
                                    Object[] args = new Object[]{ODEExternalService.access$2(1.access$0(this.this$1), this.val$partnerRoleMessageExchange.getRequest())};
                                    result = null;
                                    boolean success = false;
                                    try {
                                        result = runtimeWire.invoke(operation, args);
                                        success = true;
                                    }
                                    catch (Exception e) {
                                        this.val$partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.OTHER, e.getMessage(), null);
                                    }
                                    if (1.access$0(this.this$1).__log.isDebugEnabled()) {
                                        1.access$0(this.this$1).__log.debug((Object)"SCA Reference invocation finished");
                                        1.access$0(this.this$1).__log.debug((Object)(">>> Result : " + DOMUtils.domToString((Node)((Element)result))));
                                    }
                                    if (success) break block9;
                                    return null;
                                }
                                try {
                                    ODEExternalService.access$3(1.access$0(this.this$1), this.val$partnerRoleMessageExchange.getMessageExchangeId(), operation, (Element)result);
                                }
                                catch (Throwable t) {
                                    String errmsg = "Error sending message (mex=" + this.val$partnerRoleMessageExchange + "): " + t.getMessage();
                                    1.access$0(this.this$1).__log.error((Object)errmsg, t);
                                }
                            }
                            return null;
                        }
                    });
                }

                static /* synthetic */ ODEExternalService access$0(1 var0) {
                    return var0.ODEExternalService.this;
                }
            });
            partnerRoleMessageExchange.replyAsync();
        } else {
            this._server.getExecutor().submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
            partnerRoleMessageExchange.replyOneWayOk();
        }
    }

    private Operation findOperation(String operationName, RuntimeComponentReference runtimeComponentReference) {
        Operation reseultOperation = null;
        for (Operation operation : runtimeComponentReference.getInterfaceContract().getInterface().getOperations()) {
            if (!operationName.equalsIgnoreCase(operation.getName())) continue;
            reseultOperation = operation;
            break;
        }
        return reseultOperation;
    }

    private Element getPayload(Message odeMessage) {
        Element payload = null;
        Element parameters = odeMessage.getPart("parameters");
        if (parameters != null && parameters.hasChildNodes()) {
            payload = (Element)parameters.getFirstChild();
        }
        return payload;
    }

    private void replyTwoWayInvocation(final String odeMexId, final Operation operation, final Element result) {
        try {
            this._server.getScheduler().execIsolatedTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block3: {
                        PartnerRoleMessageExchange odeMex = null;
                        try {
                            odeMex = (PartnerRoleMessageExchange)ODEExternalService.this._server.getBpelServer().getEngine().getMessageExchange(odeMexId);
                            if (odeMex != null) {
                                Message response = ODEExternalService.this.createResponseMessage(odeMex, operation, result);
                                odeMex.reply(response);
                            }
                        }
                        catch (Exception ex) {
                            String errmsg = "Unable to process response: " + ex.getMessage();
                            if (odeMex == null) break block3;
                            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Message createResponseMessage(PartnerRoleMessageExchange partnerRoleMessageExchange, Operation operation, Element invocationResult) {
        Document dom = DOMUtils.newDocument();
        String operationName = operation.getName();
        Part bpelOperationOutputPart = (Part)((WSDLInterface)operation.getInterface()).getPortType().getOperation(operationName, null, null).getOutput().getMessage().getParts().values().iterator().next();
        Element contentMessage = dom.createElement("message");
        Element contentPart = dom.createElement(bpelOperationOutputPart.getName());
        contentPart.appendChild(dom.importNode(invocationResult, true));
        contentMessage.appendChild(contentPart);
        dom.appendChild(contentMessage);
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"Creating result message:");
            this.__log.debug((Object)(">>>" + DOMUtils.domToString((Node)dom.getDocumentElement())));
        }
        QName id = partnerRoleMessageExchange.getOperation().getOutput().getMessage().getQName();
        Message response = partnerRoleMessageExchange.createMessage(id);
        response.setMessage(dom.getDocumentElement());
        return response;
    }

    static /* synthetic */ Operation access$1(ODEExternalService oDEExternalService, String string, RuntimeComponentReference runtimeComponentReference) {
        return oDEExternalService.findOperation(string, runtimeComponentReference);
    }

    static /* synthetic */ Element access$2(ODEExternalService oDEExternalService, Message message) {
        return oDEExternalService.getPayload(message);
    }

    static /* synthetic */ void access$3(ODEExternalService oDEExternalService, String string, Operation operation, Element element) {
        oDEExternalService.replyTwoWayInvocation(string, operation, element);
    }
}

