/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import java.net.URI;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.implementation.widget.javascript.WidgetImplementationJavascriptProvider;
import org.apache.tuscany.sca.implementation.widget.provider.WidgetComponentScriptServlet;
import org.apache.tuscany.sca.implementation.widget.provider.WidgetImplementationInvoker;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;

class WidgetImplementationProvider
implements ImplementationProvider {
    private static final QName BINDING_HTTP = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding.http");
    private RuntimeComponent component;
    private WidgetImplementationJavascriptProvider javascriptProvider;
    private ComponentJavaScriptGenerator javaScriptGenerator;
    private ServletHost servletHost;
    private String widgetLocationURL;
    private String widgetFolderURL;
    private String widgetName;
    private String scriptURI;

    WidgetImplementationProvider(RuntimeComponent component, WidgetImplementation implementation, WidgetImplementationJavascriptProvider javascriptProvider, ComponentJavaScriptGenerator javaScriptGenerator, ServletHost servletHost) {
        this.component = component;
        this.javaScriptGenerator = javaScriptGenerator;
        this.servletHost = servletHost;
        this.widgetLocationURL = implementation.getLocationURL().toString();
        int s = this.widgetLocationURL.lastIndexOf(47);
        this.widgetFolderURL = this.widgetLocationURL.substring(0, s);
        this.widgetName = this.widgetLocationURL.substring(s + 1);
        this.widgetName = this.widgetName.substring(0, this.widgetName.lastIndexOf(46));
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        WidgetImplementationInvoker invoker = new WidgetImplementationInvoker(this.component, this.javaScriptGenerator, this.widgetName, this.widgetFolderURL, this.widgetLocationURL);
        return invoker;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        String baseURI = this.getBaseURI();
        this.scriptURI = URI.create(baseURI + "/" + this.widgetName + ".js").toString();
        Servlet servlet = this.servletHost.getServletMapping(this.scriptURI);
        if (servlet == null) {
            WidgetComponentScriptServlet widgetScriptServlet = new WidgetComponentScriptServlet(this.component, this.javaScriptGenerator);
            this.servletHost.addServletMapping(this.scriptURI, (Servlet)widgetScriptServlet);
        }
        if (this.javascriptProvider != null) {
            this.javascriptProvider.start();
        }
    }

    public void stop() {
        WidgetComponentScriptServlet widgetScriptServlet = (WidgetComponentScriptServlet)this.servletHost.getServletMapping(this.scriptURI);
        if (widgetScriptServlet != null) {
            this.servletHost.removeServletMapping(this.scriptURI);
        }
        if (this.javascriptProvider != null) {
            this.javascriptProvider.stop();
        }
    }

    private String getBaseURI() {
        ComponentService service;
        String baseURI = null;
        String contextPath = "/";
        if (this.servletHost != null) {
            contextPath = this.servletHost.getContextPath();
        }
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        if ((service = this.component.getService("Widget")) != null) {
            for (Binding binding : service.getBindings()) {
                if (!binding.getType().equals(BINDING_HTTP)) continue;
                String bindingURI = binding.getURI();
                URI uri = URI.create(bindingURI);
                if (uri.isAbsolute()) {
                    return bindingURI;
                }
                if (bindingURI.startsWith("/")) {
                    bindingURI = bindingURI.substring(1);
                }
                baseURI = contextPath + bindingURI;
            }
        }
        return baseURI == null ? "" : baseURI;
    }
}

