/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.implementation.widget.javascript.WidgetImplementationJavascriptProvider;
import org.apache.tuscany.sca.implementation.widget.provider.WidgetImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGeneratorExtensionPoint;

public class WidgetImplementationProviderFactory
implements ImplementationProviderFactory<WidgetImplementation> {
    private ServletHost servletHost;
    private WidgetImplementationJavascriptProvider javascriptProvider;
    private ComponentJavaScriptGenerator javascriptGenerator;

    public WidgetImplementationProviderFactory(ExtensionPointRegistry registry) {
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)registry);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.javascriptProvider = (WidgetImplementationJavascriptProvider)utilities.getUtility(WidgetImplementationJavascriptProvider.class);
        ComponentJavaScriptGeneratorExtensionPoint javascriptGeneratorExtensionPoint = (ComponentJavaScriptGeneratorExtensionPoint)registry.getExtensionPoint(ComponentJavaScriptGeneratorExtensionPoint.class);
        this.javascriptGenerator = (ComponentJavaScriptGenerator)javascriptGeneratorExtensionPoint.getComponentJavaScriptGenerators().get(0);
    }

    public ImplementationProvider createImplementationProvider(RuntimeComponent component, WidgetImplementation implementation) {
        return new WidgetImplementationProvider(component, implementation, this.javascriptProvider, this.javascriptGenerator, this.servletHost);
    }

    public Class<WidgetImplementation> getModelType() {
        return WidgetImplementation.class;
    }
}

