/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.node.Client;
import org.apache.tuscany.sca.node.Contribution;
import org.apache.tuscany.sca.node.ContributionLocationHelper;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.configuration.DefaultNodeConfigurationFactory;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeFactory
extends DefaultNodeConfigurationFactory {
    private static final String SCA_CONTRIBUTION_META = "META-INF/sca-contribution.xml";
    private static final String SCA_CONTRIBUTION_GENERATED_META = "META-INF/sca-contribution-generated.xml";
    protected static Map<String, NodeFactory> nodeFactories = new HashMap<String, NodeFactory>();
    private static volatile int count = 0;

    protected static void setNodeFactory(NodeFactory factory) {
        nodeFactories.put("http://tuscany.apache.org/sca/1.1/domains/default", factory);
    }

    public static NodeFactory getInstance(String domainURI) {
        NodeFactory nodeFactory = nodeFactories.get(domainURI);
        if (nodeFactory == null) {
            try {
                try {
                    Class<?> discoveryClass = Class.forName("org.apache.tuscany.sca.extensibility.ServiceDiscovery");
                    Object instance = discoveryClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Object factoryDeclaration = discoveryClass.getMethod("getServiceDeclaration", Class.class).invoke(instance, NodeFactory.class);
                    if (factoryDeclaration != null) {
                        Class factoryImplClass = (Class)factoryDeclaration.getClass().getMethod("loadClass", new Class[0]).invoke(factoryDeclaration, new Object[0]);
                        nodeFactory = (NodeFactory)factoryImplClass.newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (nodeFactory == null) {
                    String className = "org.apache.tuscany.sca.node.impl.NodeFactoryImpl";
                    Class<?> cls = Class.forName(className);
                    nodeFactory = (NodeFactory)cls.newInstance();
                }
            }
            catch (Exception e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
            nodeFactories.put(domainURI, nodeFactory);
        }
        return nodeFactory;
    }

    public static NodeFactory newInstance() {
        return NodeFactory.getInstance("http://tuscany.apache.org/sca/1.1/domains/default");
    }

    private static InputStream openStream(URL url) throws IOException {
        InputStream is = null;
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        is = connection.getInputStream();
        return is;
    }

    private static URI createURI(String uri) {
        int index = uri.indexOf(58);
        String scheme = null;
        String ssp = uri;
        if (index != -1) {
            scheme = uri.substring(0, index);
            ssp = uri.substring(index + 1);
        }
        try {
            return new URI(scheme, ssp, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Node createNode(URL configurationURL) {
        try {
            InputStream is = NodeFactory.openStream(configurationURL);
            NodeConfiguration configuration = this.loadConfiguration(is, configurationURL);
            return this.createNode(configuration);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Node createNode(InputStream is) {
        NodeConfiguration configuration = this.loadConfiguration(is, null);
        return this.createNode(configuration);
    }

    public Node createNode(String deploymentCompositeURI, Contribution ... contributions) {
        if (contributions == null || contributions.length == 0) {
            if (deploymentCompositeURI == null || deploymentCompositeURI.indexOf(58) != -1) {
                throw new ServiceRuntimeException("No SCA contribution is provided or discovered");
            }
            List<String> locations = ContributionLocationHelper.getContributionLocations(null, deploymentCompositeURI);
            if (locations.isEmpty()) {
                throw new ServiceRuntimeException("No SCA contributions are found on the classpath");
            }
            contributions = this.getContributions(locations);
        }
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (deploymentCompositeURI != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(NodeFactory.createURI(deploymentCompositeURI));
        }
        return this.createNode(configuration);
    }

    public final Node createNode(String deploymentCompositeURI, String[] uris, String[] locations) {
        return this.createNode(deploymentCompositeURI, this.getContributions(Arrays.asList(uris), Arrays.asList(locations)));
    }

    public final Node createNode(String deploymentCompositeURI, String[] locations) {
        return this.createNode(deploymentCompositeURI, this.getContributions(Arrays.asList(locations)));
    }

    public final Node createNode(Reader deploymentCompositeContent, String[] uris, String[] locations) {
        return this.createNode(deploymentCompositeContent, this.getContributions(Arrays.asList(uris), Arrays.asList(locations)));
    }

    public final Node createNode(String compositeURI, ClassLoader classLoader) {
        List<String> locations = ContributionLocationHelper.getContributionLocations(classLoader, compositeURI);
        return this.createNode(compositeURI, locations.toArray(new String[locations.size()]));
    }

    public Node createNode(Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        return this.createNode(configuration);
    }

    public Node createNode(InputStream compositeContent, Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (compositeContent != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(compositeContent);
        }
        return this.createNode(configuration);
    }

    public Node createNode(Reader compositeContent, Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (compositeContent != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(compositeContent);
        }
        return this.createNode(configuration);
    }

    public Node createNode() {
        ArrayList<String> locations = new ArrayList<String>();
        locations.addAll(ContributionLocationHelper.getContributionLocations(null, SCA_CONTRIBUTION_META));
        locations.addAll(ContributionLocationHelper.getContributionLocations(null, SCA_CONTRIBUTION_GENERATED_META));
        if (locations.isEmpty()) {
            throw new ServiceRuntimeException("No SCA contributions are found on the classpath");
        }
        Contribution[] contributions = this.getContributions(locations);
        return this.createNode(contributions);
    }

    private NodeConfiguration createConfiguration(Contribution ... contributions) {
        NodeFactory factory = this;
        NodeConfiguration configuration = factory.createNodeConfiguration();
        configuration.setDomainURI(this.getDomainURI());
        configuration.setURI("http://tuscany.apache.org/sca/1.1/nodes/default" + count++);
        if (contributions != null) {
            Contribution[] contributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                Contribution c = contributionArray[n2];
                configuration.addContribution(c.getURI(), c.getLocation());
                ++n2;
            }
        }
        return configuration;
    }

    private Contribution[] getContributions(List<String> locations) {
        Contribution[] contributions = new Contribution[locations.size()];
        int index = 0;
        for (String location : locations) {
            contributions[index++] = new Contribution(location, location);
        }
        return contributions;
    }

    private Contribution[] getContributions(List<String> uris, List<String> locations) {
        if (uris.size() != locations.size()) {
            throw new IllegalArgumentException("The number of URIs does not match the number of locations");
        }
        Contribution[] contributions = new Contribution[locations.size()];
        int i = 0;
        int n = locations.size();
        while (i < n) {
            contributions[i] = new Contribution(uris.get(i), locations.get(i));
            ++i;
        }
        return contributions;
    }

    public void destroy() {
        nodeFactories.remove(this.getDomainURI());
    }

    public String getDomainURI() {
        for (Map.Entry<String, NodeFactory> es : nodeFactories.entrySet()) {
            if (!es.getValue().equals(this)) continue;
            return es.getKey();
        }
        return "http://tuscany.apache.org/sca/1.1/domains/default";
    }

    public abstract Node createNode(NodeConfiguration var1);

    public abstract NodeConfiguration loadConfiguration(InputStream var1, URL var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeProxy
    implements Node,
    Client {
        private Object node;

        private NodeProxy(Object node) {
            this.node = node;
        }

        public static <T> T createProxy(Class<T> type, Object node) {
            try {
                return type.getDeclaredConstructor(Object.class).newInstance(node);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
            try {
                return (R)((ServiceReference)this.node.getClass().getMethod("cast", Object.class).invoke(this.node, target));
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> B getService(Class<B> businessInterface, String serviceName) {
            try {
                return (B)this.node.getClass().getMethod("getService", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String serviceName) {
            try {
                return (ServiceReference)this.node.getClass().getMethod("getServiceReference", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public Node start() {
            try {
                return new NodeProxy(this.node.getClass().getMethod("start", new Class[0]).invoke(this.node, new Object[0]));
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public void stop() {
            try {
                this.node.getClass().getMethod("stop", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        @Override
        public void destroy() {
            try {
                this.node.getClass().getMethod("destroy", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        private static void handleException(Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

