/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFinder {
    private static Map<URI, List<Node>> nodes = new HashMap<URI, List<Node>>();

    public static void addNode(URI domainName, Node node) {
        List<Node> domainNodes = nodes.get(domainName);
        if (domainNodes == null) {
            domainNodes = new ArrayList<Node>();
        }
        domainNodes.add(node);
        nodes.put(domainName, domainNodes);
    }

    public static Node removeNode(Node node) {
        for (List<Node> domainNodes : nodes.values()) {
            if (!domainNodes.contains(node)) continue;
            domainNodes.remove(node);
            if (domainNodes.size() < 1) {
                nodes.remove(domainNodes);
            }
            return node;
        }
        return null;
    }

    public static List<Node> getNodes(URI domainURI) {
        return nodes.get(domainURI);
    }
}

