/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.configuration.impl;

import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.node.configuration.BindingConfiguration;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.configuration.impl.BindingConfigurationImpl;
import org.apache.tuscany.sca.node.configuration.impl.ContributionConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConfigurationImpl
implements NodeConfiguration {
    private String uri = "http://tuscany.apache.org/sca/1.1/nodes/default";
    private String domainURI = "http://tuscany.apache.org/sca/1.1/domains/default";
    private String domainRegistryURI = "vm://localhost";
    private List<ContributionConfiguration> contributions = new ArrayList<ContributionConfiguration>();
    private List<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
    private List<Object> extensions = new ArrayList<Object>();

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public NodeConfiguration setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getDomainURI() {
        return this.domainURI;
    }

    @Override
    public String getDomainName() {
        URI uri;
        if (this.domainURI != null && (uri = URI.create(this.domainURI)).getHost() != null) {
            return uri.getHost();
        }
        return this.domainURI;
    }

    @Override
    public NodeConfiguration setDomainURI(String domainURI) {
        this.domainURI = domainURI;
        return this;
    }

    @Override
    public List<ContributionConfiguration> getContributions() {
        return this.contributions;
    }

    @Override
    public List<BindingConfiguration> getBindings() {
        return this.bindings;
    }

    @Override
    public NodeConfiguration addBinding(BindingConfiguration bindingConfiguration) {
        for (BindingConfiguration bc : this.bindings) {
            if (!bc.getBindingType().equals(bindingConfiguration.getBindingType())) continue;
            bc.getBaseURIs().addAll(bindingConfiguration.getBaseURIs());
            return this;
        }
        this.bindings.add(bindingConfiguration);
        return this;
    }

    @Override
    public NodeConfiguration addContribution(ContributionConfiguration contributionConfiguration) {
        this.contributions.add(contributionConfiguration);
        return this;
    }

    @Override
    public NodeConfiguration addBinding(QName bindingType, String ... baseURIs) {
        BindingConfiguration binding = new BindingConfigurationImpl().setBindingType(bindingType);
        String[] stringArray = baseURIs;
        int n = baseURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] uris;
            String u = stringArray[n2];
            String[] stringArray2 = uris = u.split("(\\s)+");
            int n3 = uris.length;
            int n4 = 0;
            while (n4 < n3) {
                String uri = stringArray2[n4];
                if (uri.length() > 0) {
                    binding.addBaseURI(uri);
                }
                ++n4;
            }
            ++n2;
        }
        return this.addBinding(binding);
    }

    @Override
    public NodeConfiguration addBinding(QName bindingType, URI ... baseURIs) {
        BindingConfiguration binding = new BindingConfigurationImpl().setBindingType(bindingType);
        URI[] uRIArray = baseURIs;
        int n = baseURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI u = uRIArray[n2];
            binding.addBaseURI(u.toString());
            ++n2;
        }
        return this.addBinding(binding);
    }

    @Override
    public NodeConfiguration addContribution(String contributionURI, String location) {
        ContributionConfigurationImpl contribution = new ContributionConfigurationImpl(contributionURI, location);
        return this.addContribution(contribution);
    }

    @Override
    public NodeConfiguration addContribution(String contributionURI, URL location) {
        return this.addContribution(contributionURI, location.toString());
    }

    @Override
    public NodeConfiguration addContribution(URI contributionURI, URL location) {
        return this.addContribution(contributionURI.toString(), location.toString());
    }

    @Override
    public NodeConfiguration addContribution(URL ... locations) {
        URL[] uRLArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            ContributionConfigurationImpl contribution = new ContributionConfigurationImpl(url.toString(), url.toString());
            this.addContribution(contribution);
            ++n2;
        }
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, InputStream content) {
        this.findContribution(contributionURI).addDeploymentComposite(content);
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, Reader content) {
        this.findContribution(contributionURI).addDeploymentComposite(content);
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, String location) {
        this.findContribution(contributionURI).addDeploymentComposite(URI.create(location));
        return this;
    }

    private ContributionConfiguration findContribution(String uri) {
        for (ContributionConfiguration c : this.contributions) {
            if (c.getURI() == null || !c.getURI().equals(uri)) continue;
            return c;
        }
        throw new IllegalArgumentException("Contribution is not found (uri=" + uri + ")");
    }

    public String toString() {
        if (this.domainURI != null) {
            return "{" + this.domainURI + "}" + this.uri;
        }
        return this.uri;
    }

    @Override
    public List<Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getDomainRegistryURI() {
        return this.domainRegistryURI;
    }

    @Override
    public NodeConfiguration setDomainRegistryURI(String domainRegistryURI) {
        this.domainRegistryURI = domainRegistryURI;
        return this;
    }
}

