/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDaemonLauncher {
    private static final Logger logger = Logger.getLogger(NodeDaemonLauncher.class.getName());

    private NodeDaemonLauncher() {
    }

    public static NodeDaemonLauncher newInstance() {
        return new NodeDaemonLauncher();
    }

    public <T> T createNodeDaemon() throws LauncherException {
        return (T)NodeLauncherUtil.nodeDaemon();
    }

    public static void main(String[] args) throws Exception {
        logger.info("Apache Tuscany SCA Node Daemon starting...");
        NodeDaemonLauncher launcher = NodeDaemonLauncher.newInstance();
        Object daemon = launcher.createNodeDaemon();
        try {
            daemon.getClass().getMethod("start", new Class[0]).invoke(daemon, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node Daemon could not be started", e);
            throw e;
        }
        logger.info("SCA Node Daemon started.");
        logger.info("Press enter to shutdown.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            daemon.getClass().getMethod("stop", new Class[0]).invoke(daemon, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node Daemon could not be stopped", e);
            throw e;
        }
    }
}

