/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLauncher {
    static final Logger logger = Logger.getLogger(NodeLauncher.class.getName());

    private NodeLauncher() {
    }

    public static NodeLauncher newInstance() {
        return new NodeLauncher();
    }

    public <T> T createNode(String configurationURI) throws LauncherException {
        return (T)NodeLauncherUtil.node(configurationURI, null, null, null);
    }

    public <T> T createNode(String compositeURI, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, null, contributions);
    }

    public <T> T createNode(String compositeURI, String compositeContent, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, compositeContent, contributions);
    }

    public static void main(String[] args) throws Exception {
        logger.info("Apache Tuscany SCA Node starting...");
        NodeLauncher launcher = NodeLauncher.newInstance();
        String configurationURI = args[0];
        logger.info("SCA Node configuration: " + configurationURI);
        Object node = launcher.createNode(configurationURI);
        try {
            node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be started", e);
            throw e;
        }
        logger.info("SCA Node started.");
        logger.info("Press enter to shutdown.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be stopped", e);
            throw e;
        }
    }

    public static final class Contribution {
        private String uri;
        private String location;

        public Contribution(String uri, String location) {
            this.uri = uri;
            this.location = location;
        }

        public String getURI() {
            return this.uri;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

