/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.wspolicy.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyOperator;
import org.apache.tuscany.sca.common.xml.stax.reader.XMLDocumentStreamReader;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.wspolicy.WSPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WSPolicy> {
    protected ExtensionPointRegistry registry;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    protected StAXAttributeProcessor<Object> extensionAttributeProcessor;
    protected XMLInputFactory inputFactory;
    protected XMLOutputFactory outputFactory;

    public WSPolicyProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        this.registry = registry;
        this.extensionProcessor = extensionProcessor;
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(XMLInputFactory.class);
        this.outputFactory = (XMLOutputFactory)modelFactories.getFactory(XMLOutputFactory.class);
    }

    public QName getArtifactType() {
        return WSPolicy.WS_POLICY_QNAME;
    }

    public Class<WSPolicy> getModelType() {
        return WSPolicy.class;
    }

    public WSPolicy read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Policy neethiPolicy = null;
        XMLDocumentStreamReader doc = new XMLDocumentStreamReader(reader);
        StAXOMBuilder builder = new StAXOMBuilder((XMLStreamReader)doc);
        OMElement element = builder.getDocumentElement();
        neethiPolicy = PolicyEngine.getPolicy((OMElement)element);
        WSPolicy wsPolicy = new WSPolicy();
        wsPolicy.setNeethiPolicy(neethiPolicy);
        neethiPolicy.normalize(true);
        for (Object alternative : neethiPolicy.getPolicyComponents()) {
            ArrayList<Object> assertions = new ArrayList<Object>();
            this.readPolicyAssertions(assertions, (PolicyComponent)alternative, context);
            wsPolicy.getPolicyAssertions().add(assertions);
        }
        return wsPolicy;
    }

    private void readPolicyAssertions(List<Object> policyAssertions, PolicyComponent policyComponent, ProcessorContext context) {
        if (policyComponent.getType() != 5) {
            PolicyOperator policyOperator = (PolicyOperator)policyComponent;
            for (Object childComponent : policyOperator.getPolicyComponents()) {
                this.readPolicyAssertions(policyAssertions, (PolicyComponent)childComponent, context);
            }
        } else {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(outputStream);
                policyComponent.serialize(writer);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(inputStream);
                PolicyComponent neethiAssertion = policyComponent;
                Object tuscanyAssertion = this.extensionProcessor.read(reader, context);
                if (tuscanyAssertion != null) {
                    policyAssertions.add(tuscanyAssertion);
                }
                policyAssertions.add(neethiAssertion);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void write(WSPolicy wsPolicy, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        if (wsPolicy != null) {
            wsPolicy.getNeethiPolicy().serialize(writer);
        }
        writer.writeEndElement();
    }

    public void resolve(WSPolicy wsPolicy, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

