/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ExampleCondition
extends AbstractRutaCondition {
    private final StringExpression dateExpr;
    private final StringExpression formatExpr;

    public ExampleCondition(StringExpression expr, StringExpression format) {
        this.dateExpr = expr;
        this.formatExpr = format;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String coveredText = annotation.getCoveredText();
        String dateValue = this.dateExpr.getStringValue((RutaStatement)element.getParent());
        String formatValue = this.formatExpr.getStringValue((RutaStatement)element.getParent());
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatValue);
        boolean result = false;
        try {
            Date matchedDate = dateFormat.parse(coveredText);
            Date givenDate = dateFormat.parse(dateValue);
            int compareTo = matchedDate.compareTo(givenDate);
            result = compareTo < 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return new EvaluatedCondition((AbstractRutaCondition)this, result);
    }

    public StringExpression getExpr() {
        return this.dateExpr;
    }

    public StringExpression getFormatExpr() {
        return this.formatExpr;
    }
}

