/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.uima.ruta.ide.core.extensions.IIDEConditionExtension;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class ExampleConditionIDEExtension
implements IIDEConditionExtension {
    private final String[] strings = new String[]{"ExampleCondition"};

    public String[] getKnownExtensions() {
        return this.strings;
    }

    public boolean checkSyntax(Expression element, RutaCheckerProblemFactory problemFactory, IProblemReporter rep) throws RecognitionException {
        if (element instanceof RutaCondition) {
            RutaCondition a = (RutaCondition)element;
            String name = a.getName();
            if (!name.equals(this.strings[0])) {
                IProblem problem = problemFactory.createUnknownConditionProblem(a);
                rep.reportProblem(problem);
                return false;
            }
            boolean ok = true;
            List childs = a.getChilds();
            if (childs.size() != 2) {
                IProblem problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 2);
                rep.reportProblem(problem);
                ok = false;
            }
            for (Expression expression : childs) {
                if (expression.getKind() == 0x200000) continue;
                IProblem problem = problemFactory.createWrongArgumentTypeProblem(expression, "StringExpression");
                rep.reportProblem(problem);
                ok = false;
            }
            return ok;
        }
        return false;
    }
}

