/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.uima.ruta.ide.core.extensions.IIDENumberFunctionExtension;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class ExampleNumberFunctionIDEExtension
implements IIDENumberFunctionExtension {
    private final String[] strings = new String[]{"ExampleNumberFunction"};

    public String[] getKnownExtensions() {
        return this.strings;
    }

    public boolean checkSyntax(Expression element, RutaCheckerProblemFactory problemFactory, IProblemReporter rep) throws RecognitionException {
        if (element instanceof RutaFunction) {
            Expression expr;
            RutaFunction f = (RutaFunction)element;
            String name = f.getName();
            if (!name.equals(this.strings[0])) {
                IProblem problem = problemFactory.createUnknownFunctionProblem(f);
                rep.reportProblem(problem);
                return false;
            }
            boolean ok = true;
            List childs = f.getChilds();
            if (childs.size() != 1) {
                IProblem problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 1);
                rep.reportProblem(problem);
                ok = false;
            }
            if ((expr = (Expression)childs.get(0)).getKind() != 0x800000) {
                IProblem problem = problemFactory.createWrongArgumentTypeProblem(expr, "TypeExpression");
                rep.reportProblem(problem);
                ok = false;
            }
            return ok;
        }
        return false;
    }
}

