/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleAction
extends AbstractRutaAction {
    private List<NumberExpression> indexExprList;

    public ExampleAction(List<NumberExpression> indexExprList) {
        this.indexExprList = indexExprList;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (NumberExpression each : this.indexExprList) {
            RutaBlock parent = element.getParent();
            int integerValue = each.getIntegerValue(parent, match, element, stream);
            indexes.add(integerValue);
        }
        List ruleElements = element.getContainer().getRuleElements();
        for (Integer each : indexes) {
            if (each <= 0 || each > ruleElements.size()) continue;
            Type type = this.getRandomType(stream);
            RuleElement ruleElement = (RuleElement)ruleElements.get(each - 1);
            List matchedAnnotationsOf = match.getMatchedAnnotationsOf(ruleElement);
            for (AnnotationFS eachMatched : matchedAnnotationsOf) {
                AnnotationFS newAFS = stream.getCas().createAnnotation(type, eachMatched.getBegin(), eachMatched.getEnd());
                stream.addAnnotation(newAFS, true, (AbstractRuleMatch)match);
            }
        }
    }

    private Type getRandomType(RutaStream stream) {
        Type annotationType = stream.getCas().getAnnotationType();
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        List subsumedTypes = typeSystem.getProperlySubsumedTypes(annotationType);
        Random r = new Random();
        int nextInt = r.nextInt(subsumedTypes.size());
        return (Type)subsumedTypes.get(nextInt);
    }

    public List<NumberExpression> getIndexExprList() {
        return this.indexExprList;
    }

    public void setIndexExprList(List<NumberExpression> indexExprList) {
        this.indexExprList = indexExprList;
    }
}

