/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.string.AbstractStringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ExampleCondition
extends AbstractRutaCondition {
    private final AbstractStringExpression dateExpr;
    private final AbstractStringExpression formatExpr;

    public ExampleCondition(AbstractStringExpression expr, AbstractStringExpression format) {
        this.dateExpr = expr;
        this.formatExpr = format;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String coveredText = annotation.getCoveredText();
        String dateValue = this.dateExpr.getStringValue(element.getParent(), annotation, stream);
        String formatValue = this.formatExpr.getStringValue(element.getParent(), annotation, stream);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatValue);
        boolean result = false;
        try {
            Date matchedDate = dateFormat.parse(coveredText);
            Date givenDate = dateFormat.parse(dateValue);
            int compareTo = matchedDate.compareTo(givenDate);
            result = compareTo < 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return new EvaluatedCondition((AbstractRutaCondition)this, result);
    }

    public AbstractStringExpression getExpr() {
        return this.dateExpr;
    }

    public AbstractStringExpression getFormatExpr() {
        return this.formatExpr;
    }
}

