/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.tools.config.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration<T> {
    private Map<String, Object> simpleProperties = new HashMap<String, Object>();
    private List<Property> convertableProperties = new ArrayList<Property>();

    public void addProperty(Property property) {
        this.convertableProperties.add(property);
    }

    public boolean removeProperty(Property property) {
        return this.convertableProperties.remove(property);
    }

    public List<Property> getConvertableProperties() {
        return this.convertableProperties;
    }

    public void setProperty(String name, String value) {
        if ("true".equals(value)) {
            this.setProperty(name, Boolean.TRUE);
        } else if ("false".equals(value)) {
            this.setProperty(name, Boolean.FALSE);
        } else {
            this.simpleProperties.put(name, value);
        }
    }

    public void setProperty(String name, Object value) {
        this.simpleProperties.put(name, value);
    }

    public Object removeProperty(String name) {
        return this.simpleProperties.remove(name);
    }

    public boolean hasProperties() {
        return !this.simpleProperties.isEmpty() || !this.convertableProperties.isEmpty();
    }

    public Map<String, Object> getSimpleProperties() {
        return this.simpleProperties;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> all = new HashMap<String, Object>(this.simpleProperties);
        for (Property property : this.getConvertableProperties()) {
            all.put(property.getName(), property.getConvertedValue());
        }
        return all;
    }

    public void addConfiguration(Configuration<T> config) {
        for (Property prop : config.getConvertableProperties()) {
            this.addProperty(prop);
        }
        Map<String, Object> simples = config.getSimpleProperties();
        for (String name : simples.keySet()) {
            this.setProperty(name, simples.get(name));
        }
    }

    public void validate() {
        for (Property property : this.getConvertableProperties()) {
            property.validate();
        }
    }

    protected void appendProperties(StringBuilder out) {
        if (this.hasProperties()) {
            Map<String, Object> props = this.getProperties();
            out.append("with ");
            out.append(props.size());
            out.append(" properties [");
            for (String name : props.keySet()) {
                out.append(name);
                out.append(" => ");
                out.append(props.get(name));
                out.append("; ");
            }
            out.append("]");
        }
    }
}

