/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.config.ConfigurationException;
import org.apache.velocity.tools.config.NullKeyException;

public class Data {
    private String key;
    private Object value;
    private DataConverter converter;

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setClassname(String classname) {
        try {
            this.setTargetClass(ClassUtils.getClass(classname));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Class " + classname + " could not be found.", cnfe);
        }
    }

    public void setClass(String classname) {
        this.setClassname(classname);
    }

    public void setType(String type) {
        DataConverter dc = this.getDataConverter(type);
        if (dc != null) {
            this.converter = dc;
        } else {
            this.setClassname(type);
        }
    }

    public void setTargetClass(Class clazz) {
        if (this.converter == null) {
            this.converter = new DataConverter();
        }
        this.converter.setTarget(clazz);
    }

    public void setConverter(String classname) {
        try {
            this.convertWith((Converter)ClassUtils.getInstance(classname));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + classname + " is not a valid " + Converter.class, e);
        }
    }

    public void convertWith(Converter converter) {
        if (this.converter == null) {
            this.converter = new DataConverter();
        }
        this.converter.setConverter(converter);
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getTargetClass() {
        if (this.converter == null) {
            return String.class;
        }
        return this.converter.getTarget();
    }

    public Converter getConverter() {
        if (this.converter == null) {
            return null;
        }
        return this.converter.getConverter();
    }

    public Object getConvertedValue() {
        if (this.converter == null) {
            return this.value;
        }
        return this.converter.convert(this.getValue());
    }

    public void validate() {
        if (this.getKey() == null) {
            throw new NullKeyException(this);
        }
        if (this.getValue() == null) {
            throw new ConfigurationException(this, "No value has been set for '" + this.getKey() + '\'');
        }
        if (this.converter != null) {
            try {
                this.getConvertedValue();
            }
            catch (Throwable t) {
                throw new ConfigurationException(this, t);
            }
        }
    }

    protected DataConverter getDataConverter(String type) {
        DataConverter dc;
        if (type.startsWith("list.")) {
            dc = new ListConverter();
            type = type.substring(5, type.length());
        } else {
            if (type.equals("list")) {
                return new ListConverter();
            }
            dc = new DataConverter();
        }
        if (type.equals("boolean")) {
            dc.setTarget(Boolean.class);
            dc.setConverter((Converter)new BooleanConverter());
        } else if (type.equals("number")) {
            if (this.getValue() != null && this.getValue().toString().indexOf(46) < 0) {
                dc.setConverter((Converter)new IntegerConverter());
                dc.setTarget(Integer.class);
            } else {
                dc.setConverter((Converter)new DoubleConverter());
                dc.setTarget(Double.class);
            }
        } else if (type.equals("string")) {
            dc.setTarget(String.class);
            dc.setConverter((Converter)new StringConverter());
        } else {
            return null;
        }
        return dc;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Data '");
        out.append(this.key);
        out.append('\'');
        out.append(" -> ");
        out.append(this.value);
        return out.toString();
    }

    protected static class ListConverter
    extends DataConverter {
        protected ListConverter() {
        }

        public List convert(Object val) {
            String value = (String)val;
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            List<String> list = Arrays.asList(value.split(","));
            if (this.getConverter() == null || this.getTarget() == String.class) {
                return list;
            }
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (String item : list) {
                convertedList.add(super.convert(item));
            }
            return convertedList;
        }
    }

    protected static class DataConverter {
        private Converter converter;
        private Class target = String.class;

        protected DataConverter() {
        }

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public Converter getConverter() {
            return this.converter;
        }

        public void setTarget(Class target) {
            this.target = target;
        }

        public Class getTarget() {
            return this.target;
        }

        public Object convert(Object value) {
            if (this.converter == null) {
                return value;
            }
            return this.converter.convert(this.target, value);
        }
    }
}

