/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.lang.reflect.Method;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.OldToolInfo;
import org.apache.velocity.tools.ToolInfo;
import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.ConfigurationException;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.InvalidScope;
import org.apache.velocity.tools.config.NullKeyException;
import org.apache.velocity.tools.config.ValidScope;

public class ToolConfiguration
extends Configuration {
    private String key;
    private String classname;
    private String restrictTo;
    private Status status;
    private Throwable problem;

    public void setKey(String key) {
        this.key = key;
    }

    public void setClass(Class clazz) {
        this.setClassname(clazz.getName());
    }

    public void setClassname(String classname) {
        this.classname = classname;
        this.status = null;
    }

    public void setRestrictTo(String path) {
        this.restrictTo = path;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.getClassname() != null) {
            Class clazz = this.getToolClass();
            DefaultKey defaultKey = clazz.getAnnotation(DefaultKey.class);
            if (defaultKey != null) {
                return defaultKey.value();
            }
            return clazz.getSimpleName();
        }
        return null;
    }

    public String getClassname() {
        return this.classname;
    }

    public Class getToolClass() {
        try {
            return ClassUtils.getClass(this.getClassname());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException((Configuration)this, (Throwable)cnfe);
        }
    }

    public String[] getInvalidScopes() {
        InvalidScope invalid = this.getToolClass().getAnnotation(InvalidScope.class);
        if (invalid != null) {
            return invalid.value();
        }
        return new String[0];
    }

    public String[] getValidScopes() {
        ValidScope valid = this.getToolClass().getAnnotation(ValidScope.class);
        if (valid != null) {
            return valid.value();
        }
        return new String[0];
    }

    private final Status getStatus() {
        if (this.status == null) {
            if (this.getClassname() == null) {
                this.status = Status.NONE;
            }
            try {
                Class clazz = ClassUtils.getClass(this.getClassname());
                this.digForDependencies(clazz);
                clazz.newInstance();
                Method init = clazz.getMethod("init", Object.class);
                Deprecated bc = init.getAnnotation(Deprecated.class);
                if (bc == null) {
                    this.status = Status.OLD;
                    this.problem = null;
                } else {
                    this.status = Status.VALID;
                    this.problem = null;
                }
            }
            catch (NoSuchMethodException nsme) {
                this.status = Status.VALID;
                this.problem = null;
            }
            catch (ClassNotFoundException cnfe) {
                this.status = Status.MISSING;
                this.problem = cnfe;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.status = Status.UNSUPPORTED;
                this.problem = ncdfe;
            }
            catch (Throwable t) {
                this.status = Status.UNINSTANTIABLE;
                this.problem = t;
            }
        }
        return this.status;
    }

    private void digForDependencies(Class clazz) {
        clazz.getDeclaredMethods();
        clazz.getDeclaredFields();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.digForDependencies(superClass);
        }
    }

    public String getRestrictTo() {
        return this.restrictTo;
    }

    public ToolInfo createInfo() {
        ToolInfo info = null;
        Status status = this.getStatus();
        switch (status) {
            case VALID: {
                info = new ToolInfo(this.getKey(), this.getToolClass());
                break;
            }
            case OLD: {
                info = new OldToolInfo(this.getKey(), this.getToolClass());
                break;
            }
            default: {
                throw new ConfigurationException((Configuration)this, this.getError(status));
            }
        }
        info.restrictTo(this.getRestrictTo());
        info.addProperties(this.getProperties());
        return info;
    }

    private final String getError(Status status) {
        switch (status) {
            case NONE: {
                return "No classname set for: " + this;
            }
            case MISSING: {
                return "Couldn't find tool class in the classpath for: " + this + "(" + this.problem + ")";
            }
            case UNSUPPORTED: {
                return "Couldn't find necessary supporting classes for: " + this + "(" + this.problem + ")";
            }
            case UNINSTANTIABLE: {
                return "Couldn't instantiate instance of tool for: " + this + "(" + this.problem + ")";
            }
        }
        return "";
    }

    public void validate() {
        super.validate();
        if (this.getKey() == null) {
            throw new NullKeyException(this);
        }
        Status status = this.getStatus();
        switch (status) {
            case VALID: 
            case OLD: {
                break;
            }
            default: {
                throw new ConfigurationException((Configuration)this, this.getError(status));
            }
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.getClassname() == null) {
            out.append("Tool '");
            out.append(this.key);
        } else {
            switch (this.getStatus()) {
                case VALID: {
                    break;
                }
                case OLD: {
                    out.append("Old ");
                    break;
                }
                case NONE: 
                case MISSING: {
                    out.append("Invalid ");
                    break;
                }
                case UNSUPPORTED: {
                    out.append("Unsupported ");
                    break;
                }
                case UNINSTANTIABLE: {
                    out.append("Unusable ");
                }
            }
            out.append("Tool '");
            out.append(this.getKey());
        }
        out.append("' ");
        out.append("=> ");
        out.append(this.getClassname());
        if (this.getRestrictTo() != null) {
            out.append(" only for '");
            out.append(this.getRestrictTo());
            out.append('\'');
        }
        out.append(" ");
        this.appendProperties(out);
        return out.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        VALID,
        OLD,
        NONE,
        MISSING,
        UNSUPPORTED,
        UNINSTANTIABLE;

    }
}

