/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.AbstractLockConfig;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="render")
public class RenderTool
extends AbstractLockConfig {
    public static final int DEFAULT_PARSE_DEPTH = 20;
    @Deprecated
    public static final String KEY_PARSE_DEPTH = "parse.depth";
    @Deprecated
    public static final String KEY_CATCH_EXCEPTIONS = "catch.exceptions";
    private static final String LOG_TAG = "RenderTool.eval()";
    private VelocityEngine engine = null;
    private int parseDepth = 20;
    private boolean catchExceptions = true;

    protected void configure(ValueParser parser) {
        Boolean catchEm;
        Integer depth = parser.getInteger(KEY_PARSE_DEPTH);
        if (depth != null) {
            this.setParseDepth(depth);
        }
        if ((catchEm = parser.getBoolean(KEY_CATCH_EXCEPTIONS)) != null) {
            this.setCatchExceptions(catchEm);
        }
    }

    public void setVelocityEngine(VelocityEngine ve) {
        this.engine = ve;
    }

    public void setParseDepth(int depth) {
        if (!this.isConfigLocked()) {
            this.parseDepth = depth;
        }
    }

    public int getParseDepth() {
        return this.parseDepth;
    }

    public void setCatchExceptions(boolean catchExceptions) {
        if (!this.isConfigLocked()) {
            this.catchExceptions = catchExceptions;
        }
    }

    public boolean getCatchExceptions() {
        return this.catchExceptions;
    }

    public String eval(Context ctx, String vtl) throws Exception {
        if (this.catchExceptions) {
            try {
                return this.internalEval(ctx, vtl);
            }
            catch (Exception e) {
                String msg = "RenderTool.eval() threw Exception: " + e;
                if (this.engine == null) {
                    Velocity.getLog().debug((Object)msg);
                } else {
                    this.engine.getLog().debug((Object)msg);
                }
                return null;
            }
        }
        return this.internalEval(ctx, vtl);
    }

    private String internalEval(Context ctx, String vtl) throws Exception {
        if (vtl == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        boolean success = this.engine == null ? Velocity.evaluate((Context)ctx, (Writer)sw, (String)LOG_TAG, (String)vtl) : this.engine.evaluate(ctx, (Writer)sw, LOG_TAG, vtl);
        if (success) {
            return sw.toString();
        }
        return null;
    }

    public String recurse(Context ctx, String vtl) throws Exception {
        return this.internalRecurse(ctx, vtl, 0);
    }

    protected String internalRecurse(Context ctx, String vtl, int count) throws Exception {
        String result = this.eval(ctx, vtl);
        if (result == null || result.equals(vtl)) {
            return result;
        }
        if (count < this.parseDepth) {
            return this.internalRecurse(ctx, result, count++);
        }
        return result;
    }
}

