/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.view.VelocityView;

public class ServletUtils {
    public static final String VELOCITY_VIEW_KEY = VelocityView.class.getName();

    public static String getPath(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String info = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path == null) {
            path = request.getServletPath();
            info = request.getPathInfo();
        }
        if (info != null) {
            path = path + info;
        }
        return path;
    }

    public static VelocityView getVelocityView(ServletConfig config) {
        ServletContext application = config.getServletContext();
        VelocityView view = (VelocityView)application.getAttribute(VELOCITY_VIEW_KEY);
        if (view == null) {
            view = new VelocityView(config);
            application.setAttribute(VELOCITY_VIEW_KEY, (Object)view);
        }
        return view;
    }

    public static Object findTool(String key, ServletContext application) {
        return ServletUtils.findTool(key, VelocityView.DEFAULT_TOOLBOX_KEY, application);
    }

    public static Object findTool(String key, String toolboxKey, ServletContext application) {
        Toolbox toolbox = (Toolbox)application.getAttribute(toolboxKey);
        if (toolbox != null) {
            return toolbox.get(key);
        }
        return null;
    }

    public static Object findTool(String key, HttpServletRequest request) {
        return ServletUtils.findTool(key, request, null);
    }

    public static Object findTool(String key, String toolboxKey, HttpServletRequest request) {
        return ServletUtils.findTool(key, toolboxKey, request, null);
    }

    public static Object findTool(String key, HttpServletRequest request, ServletContext application) {
        return ServletUtils.findTool(key, VelocityView.DEFAULT_TOOLBOX_KEY, request, application);
    }

    public static Object findTool(String key, String toolboxKey, HttpServletRequest request, ServletContext application) {
        Object tool;
        String path = ServletUtils.getPath(request);
        Toolbox toolbox = (Toolbox)request.getAttribute(toolboxKey);
        if (toolbox != null && (tool = toolbox.get(key, path)) != null) {
            return tool;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            Object tool2;
            toolbox = (Toolbox)session.getAttribute(toolboxKey);
            if (toolbox != null && (tool2 = toolbox.get(key, path)) != null) {
                return tool2;
            }
            if (application == null) {
                application = session.getServletContext();
            }
        }
        if (application != null && (toolbox = (Toolbox)application.getAttribute(toolboxKey)) != null) {
            return toolbox.get(key, path);
        }
        return null;
    }
}

