/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hama;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public abstract class HamaClusterActionHandler
extends ClusterActionHandlerSupport {
    protected synchronized Configuration getConfiguration(ClusterSpec clusterSpec) throws IOException {
        return this.getConfiguration(clusterSpec, "whirr-hama-default.properties");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        HamaClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[]{"-c", clusterSpec.getProvider()}));
        HamaClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_java", (String[])new String[0]));
        HamaClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        String hamaInstallFunction = this.getConfiguration(clusterSpec).getString("whirr.hama.install-function", "install_hama");
        String tarurl = this.prepareRemoteFileUrl(event, this.getConfiguration(clusterSpec).getString("whirr.hama.tarball.url"));
        HamaClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)hamaInstallFunction, (String[])new String[]{"-c", clusterSpec.getProvider(), "-u", tarurl}));
    }
}

