/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.kerberos;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public abstract class KerberosBaseHandler
extends ClusterActionHandlerSupport {
    protected Configuration getConfiguration(ClusterSpec spec) throws IOException {
        return this.getConfiguration(spec, "whirr-kerberos-default.properties");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        KerberosBaseHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        KerberosBaseHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        KerberosBaseHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(event.getClusterSpec().getConfiguration(), "java", "install_openjdk"), (String[])new String[0]));
        KerberosBaseHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_kerberos_client", (String[])new String[0]));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster.Instance kerberosServerInstance = null;
        try {
            kerberosServerInstance = event.getCluster().getInstanceMatching(RolePredicates.role((String)"kerberosserver"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (kerberosServerInstance != null) {
            KerberosBaseHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_kerberos_client", (String[])new String[]{"-h", kerberosServerInstance.getPublicHostName()}));
        }
    }
}

