/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies.role.annotations;

import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.AbstractRoleAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authorization.strategies.role.Roles;
import org.apache.wicket.authorization.strategies.role.annotations.AuthorizeAction;
import org.apache.wicket.authorization.strategies.role.annotations.AuthorizeActions;
import org.apache.wicket.authorization.strategies.role.annotations.AuthorizeInstantiation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsRoleAuthorizationStrategy
extends AbstractRoleAuthorizationStrategy {
    public AnnotationsRoleAuthorizationStrategy(IRoleCheckingStrategy roleCheckingStrategy) {
        super(roleCheckingStrategy);
    }

    public <T extends Component> boolean isInstantiationAuthorized(Class<T> componentClass) {
        AuthorizeInstantiation classAnnotation;
        AuthorizeInstantiation packageAnnotation;
        boolean authorized = true;
        Package componentPackage = componentClass.getPackage();
        if (componentPackage != null && (packageAnnotation = componentPackage.getAnnotation(AuthorizeInstantiation.class)) != null) {
            authorized = this.hasAny(new Roles(packageAnnotation.value()));
        }
        if ((classAnnotation = componentClass.getAnnotation(AuthorizeInstantiation.class)) != null) {
            authorized = this.hasAny(new Roles(classAnnotation.value()));
        }
        return authorized;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        Class<?> componentClass = component.getClass();
        if (!this.check(action, componentClass.getAnnotation(AuthorizeAction.class))) {
            return false;
        }
        AuthorizeActions authorizeActionsAnnotation = componentClass.getAnnotation(AuthorizeActions.class);
        if (authorizeActionsAnnotation != null) {
            for (AuthorizeAction authorizeActionAnnotation : authorizeActionsAnnotation.actions()) {
                if (this.check(action, authorizeActionAnnotation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean check(Action action, AuthorizeAction authorizeActionAnnotation) {
        if (authorizeActionAnnotation != null && action.getName().equals(authorizeActionAnnotation.action())) {
            if (this.hasAny(new Roles(authorizeActionAnnotation.deny()))) {
                return false;
            }
            Roles roles = new Roles(authorizeActionAnnotation.roles());
            if (!this.isEmpty(roles) && !this.hasAny(roles)) {
                return false;
            }
        }
        return true;
    }
}

