/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authentication.panel;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.authentication.AuthenticatedWebSession;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.ValueMap;

public class SignInPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean includeRememberMe = true;
    private PasswordTextField password;
    private boolean rememberMe = true;
    private TextField<String> username;

    public SignInPanel(String id) {
        this(id, true);
    }

    public SignInPanel(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        this.add(new Component[]{feedback});
        this.add(new Component[]{new SignInForm("signInForm")});
    }

    public final void forgetMe() {
        this.getPage().removePersistedFormData(SignInForm.class, true);
    }

    public String getPassword() {
        return this.password.getInput();
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public String getUsername() {
        return this.username.getDefaultModelObjectAsString();
    }

    public void setPersistent(boolean enable) {
        this.username.setPersistent(enable);
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
        this.setPersistent(rememberMe);
    }

    public boolean signIn(String username, String password) {
        return AuthenticatedWebSession.get().signIn(username, password);
    }

    protected void onSignInFailed() {
        this.error((Serializable)((Object)this.getLocalizer().getString("signInFailed", (Component)this, "Sign in failed")));
    }

    protected void onSignInSucceeded() {
        if (!this.continueToOriginalDestination()) {
            this.setResponsePage(this.getApplication().getSessionSettings().getPageFactory().newPage(this.getApplication().getHomePage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SignInForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;
        private final ValueMap properties;

        public SignInForm(String id) {
            super(id);
            this.properties = new ValueMap();
            this.add(new Component[]{SignInPanel.this.username = new TextField("username", (IModel)new PropertyModel((Object)this.properties, "username"))});
            this.add(new Component[]{SignInPanel.this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this.properties, "password"))});
            WebMarkupContainer rememberMeRow = new WebMarkupContainer("rememberMeRow");
            this.add(new Component[]{rememberMeRow});
            rememberMeRow.add(new Component[]{new CheckBox("rememberMe", (IModel)new PropertyModel((Object)SignInPanel.this, "rememberMe"))});
            SignInPanel.this.setPersistent(SignInPanel.this.rememberMe);
            rememberMeRow.setVisible(SignInPanel.this.includeRememberMe);
        }

        public final void onSubmit() {
            if (SignInPanel.this.signIn(SignInPanel.this.getUsername(), SignInPanel.this.getPassword())) {
                SignInPanel.this.onSignInSucceeded();
            } else {
                SignInPanel.this.onSignInFailed();
            }
        }
    }
}

