/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authorization.strategies.role;

import java.util.Collection;
import java.util.HashSet;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.StringList;

public final class Roles
extends HashSet<String>
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String USER = "USER";
    public static final String ADMIN = "ADMIN";

    public Roles() {
    }

    public Roles(String roles) {
        for (String role : roles.split("\\s*,\\s*")) {
            this.add(role);
        }
    }

    public Roles(String[] roles) {
        for (String role : roles) {
            this.add(role);
        }
    }

    public boolean hasRole(String role) {
        if (role != null) {
            return this.contains(role);
        }
        return false;
    }

    public boolean hasAnyRole(Roles roles) {
        if (roles != null) {
            for (String role : roles) {
                if (!this.hasRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAllRoles(Roles roles) {
        if (roles != null) {
            for (String role : roles) {
                if (this.hasRole(role)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return StringList.valueOf((Collection)this).join();
    }
}

