/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.diskstore.browser;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.diskstore.browser.BrowserTable;
import org.apache.wicket.devutils.diskstore.browser.PageWindowColumn;
import org.apache.wicket.devutils.diskstore.browser.PageWindowDescription;
import org.apache.wicket.devutils.diskstore.browser.PageWindowProvider;
import org.apache.wicket.devutils.diskstore.browser.SessionsProviderModel;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;

public class BrowserPanel
extends Panel {
    public BrowserPanel(String id) {
        super(id);
        final DropDownChoice<String> sessionsSelector = this.createSessionsSelector("sessions");
        this.add(new Component[]{sessionsSelector});
        final BrowserTable table = this.createTable("table", (IModel<String>)sessionsSelector.getModel());
        this.add(new Component[]{table});
        AjaxFallbackLink<Void> refreshLink = new AjaxFallbackLink<Void>("refresh"){

            public void onClick(AjaxRequestTarget target) {
                if (target != null) {
                    target.add(new Component[]{table});
                }
            }
        };
        this.add(new Component[]{refreshLink});
        AjaxFallbackLink<Void> currentSessionLink = new AjaxFallbackLink<Void>("currentSessionLink"){

            public void onClick(AjaxRequestTarget target) {
                sessionsSelector.setModelObject(BrowserPanel.this.getCurrentSession().getObject());
                if (target != null) {
                    target.add(new Component[]{sessionsSelector, table});
                }
            }

            public boolean isVisible() {
                return !BrowserPanel.this.getSession().isTemporary();
            }
        };
        currentSessionLink.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{currentSessionLink});
        sessionsSelector.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{table});
            }
        }});
    }

    private DropDownChoice<String> createSessionsSelector(String id) {
        IModel<String> defaultSession = this.getCurrentSession();
        DropDownChoice sessionsSelector = new DropDownChoice("sessions", defaultSession, (IModel)new SessionsProviderModel());
        return sessionsSelector;
    }

    private IModel<String> getCurrentSession() {
        return Model.of((Serializable)((Object)this.getSession().getId()));
    }

    private BrowserTable createTable(String id, IModel<String> sessionId) {
        PageWindowProvider provider = new PageWindowProvider(sessionId);
        ArrayList<IColumn<PageWindowDescription, String>> columns = new ArrayList<IColumn<PageWindowDescription, String>>();
        PageWindowColumn pageIdColumn = new PageWindowColumn((IModel<String>)Model.of((Serializable)((Object)"Id")), "id");
        columns.add((IColumn<PageWindowDescription, String>)pageIdColumn);
        PageWindowColumn pageNameColumn = new PageWindowColumn((IModel<String>)Model.of((Serializable)((Object)"Name")), "name");
        columns.add((IColumn<PageWindowDescription, String>)pageNameColumn);
        PageWindowColumn pageSizeColumn = new PageWindowColumn((IModel<String>)Model.of((Serializable)((Object)"Size")), "size");
        columns.add((IColumn<PageWindowDescription, String>)pageSizeColumn);
        BrowserTable browserTable = new BrowserTable(id, columns, provider);
        browserTable.setOutputMarkupId(true);
        browserTable.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)5))});
        return browserTable;
    }
}

